;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Engine/param.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:59:39 1993                          */
;*    Last change :  Wed Jun  1 15:47:03 1994 (serrano)                */
;*                                                                     */
;*    Les variables qui indiquent ce que doit faire bigloo.            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  tools_module
	    (tools_date "Tools/date.scm") ;; ce fichier est genere.
	    engine_path)                  ;; il ne peut pas etre dans le
   (export  *bigloo-name*                 ;; .afile
	    *bigloo-level*
	    *bigloo-cmd-name*  
	    *bigloo-args*
	    *rest-args*
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*
	    *bigloo-tmp*
	    *lib-mode*         
	    *silent*           
	    *verbose*
	    *hello?*
	    *warning*          
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*     
	    *optim*
	    *optim-cons*
	    *superlift?*
	    *inlining?*
	    *genericity*
	    *shared-data*
	    *alpha*            
	    *nil*              
	    *debug*            
	    *extra-debug*      
	    *c-debug*          
	    *c-debug-option*
	    *imediat-error*
	    *error-shape*
	    *assert*
	    *pp-env-mode*      
	    *src*              
	    *tmp-dest*         
	    *dest*
	    *cc*               
	    *ansi-cc*               
	    *cc-options*       
	    *gcc*
	    *rm-c-files*       
	    *ld-options*       
	    *strip*            
	    *bigloo-lib*
	    *bigloo-user-lib*
	    *lib-dir*
	    *bigloo-user-includes*
	    *include-dir*
	    *include-foreign*  
	    *indent*           
	    *access-file*      
	    *access-table*     
	    *o-files*          
	    *with-files*
	    *order-init-modules*
	    *used-modules*
	    *init-functions*   
	    *interpreter*      
	    *startup-file*     
	    *eval?*            
	    *call/cc?*         
	    *pass*             
	    *inline-level-max*
	    *separateur*       
	    *heap-names*
	    *heap-append?*
	    *main*             
	    *module-name*
	    *extend-entry*
	    *auto-mode*
	    (initialisation-name)))
	     
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
(define *bigloo-name*       "Bigloo (v1.6)")
(define *bigloo-level*      #\c)
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *rest-args*         '())
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "Manuel.Serrano@inria.fr")
(define *bigloo-date*       (bigloo-date))
(define *bigloo-tmp*        (let ((Venv (getenv "TMPDIR")))
			       (if (string? Venv)
				   Venv
				   "/tmp")))
   
;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(define *silent*            #f)        ;; veut-on etre tres silencieux ?
(define *verbose*           #f)        ;; veut-on etre tres bavard ?
(define *hello?*            #t)        ;; veut-on le nom du source ?
(define *warning*           #t)        ;; Et les warning ?
(define *pp-env-mode*       'short)    ;; On trace en petit, par defaut

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
(define *src*               #f)        ;; Le #t par default signifie que
(define *tmp-dest*          #f)        ;; si l'utilisateur ne precise pas
(define *dest*              #f)        ;; de fichier on lira sur la console.

;*---------------------------------------------------------------------*/
;*    Les versions de ce qu'on lit et de ce qu'on ecrit                */
;*---------------------------------------------------------------------*/
(define *separateur*        "@")

;*---------------------------------------------------------------------*/
;*    La profondeur maximum des inlines                                */
;*---------------------------------------------------------------------*/
(define *inline-level-max*  4)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
(define *cc*                   (default-c-compiler))
(define *ansi-cc*              #t)
(define *cc-options*           "")
(define *gcc*                  #f)
(define *rm-c-files*           #t)
(define *ld-options*           "")
(define *strip*                #f)
(define *bigloo-lib*           '("-lm" "-lbigloo"))
(define *bigloo-user-lib*      '())
(define *bigloo-user-includes* '())
(define *lib-dir*              (get-lib-dir))
(define *include-dir*          (get-inc-dir))
(define *include-foreign*      `("bigloo.h"))
(define *heap-names*           (list
				(string-append (get-lib-dir) "/bigloo.heap")))
(define *heap-append?*         #f)
(define *indent*               "indent")
(define *c-debug*              #f)
(define *c-debug-option*       "-g")

;*---------------------------------------------------------------------*/
;*    Les fichier de link                                              */
;*---------------------------------------------------------------------*/
(define *access-file*        #f)    ;; fichier d'indirection
(define *access-table*       '())   ;; la table d'indirection
(define *o-files*            '())   ;; avec quels fichiers link-t-on ?
(define *with-files*         '())   ;; les modules pour faire l'application
(define *used-modules*       '())   ;; la liste des modules a utiliser
(define *order-init-modules* '())   ;; l'ordre d'initialisation des modules
(define *init-functions*     '())   ;; la liste des fonctions d'initialisation
   
;*---------------------------------------------------------------------*/
;*    Les differentes pass de la compilation                           */
;*---------------------------------------------------------------------*/
(define *interpreter*       #f)     ;; compile-t-on ou interprete-t-on ?
(define *startup-file*      #f)     ;; le fichier `rc' de l'interprete
(define *eval?*             #f)
(define *call/cc?*          #f)
(define *pass*             'ld)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(define *unsafe-type*       #f)
(define *unsafe-arity*      #f)
(define *unsafe-range*      #f)
(define *unsafe-struct*     #f)
(define *debug*             #f)
(define *extra-debug*       #f)
(define *assert*            #f)
(define *imediat-error*     #f)
(define *error-shape*       #f)
(define *alpha*             #t)
(define *nil*               #t)
(define *optim*             0)
(define *optim-cons*        #f)
(define *superlift?*        #f)
(define *inlining?*         #t)
(define *genericity*        #t)
(define *shared-data*       #f)
(define *lib-mode*          #f)

;*---------------------------------------------------------------------*/
;*    Le nom du module qu'on est en train de compiler                  */
;*---------------------------------------------------------------------*/
(define *module-name*       #f)

;*---------------------------------------------------------------------*/
;*    Le point d'entree de la compilation                              */
;*---------------------------------------------------------------------*/
(define *main*              #f)

;*---------------------------------------------------------------------*/
;*    initialisation-name ...                                          */
;*---------------------------------------------------------------------*/
(define (initialisation-name)
   (module-init-name *module-name*))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(define *extend-entry*      #f)

;*---------------------------------------------------------------------*/
;*    Les auto-modes (comme en emacs)                                  */
;*---------------------------------------------------------------------*/
(define *auto-mode*         '(("ml"  . "caml")
			      ("mli" . "caml")
			      ("oon" . "meroon")))

