;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../read-init.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 18:38:46 1993                          */
;*    Last change :  Fri Nov 26 16:17:14 1993 (serrano)                */
;*                                                                     */
;*    Le trippotage de la fonction d'initialisation                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_read_init
   (include "Var/variable.sch")
   (import  var_env
	    var_declare
	    cnst_read_alloc
	    cnst_module
	    heap_abstract
	    engine_param)
   (export  (cnst-init-read-module! form)))

;*---------------------------------------------------------------------*/
;*    cnst-init-read-module! ...                                       */
;*    -------------------------------------------------------------    */
;*    Il faut rajouter dans la fonction d'initialisation du module     */
;*    toutes les pre-allocations.                                      */
;*---------------------------------------------------------------------*/
(define (cnst-init-read-module! var)
   (let* ((old-body     (function-body (global-value var)))
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Attention, il est important que `cnst' soit fait avant           */
;*    `module', car sinon, l'initialisation du module contenant le     */
;*    lecteur peut ne pas etre faite.                                  */
;*---------------------------------------------------------------------*/
	  (cnst         (read-cnst-initialisation))
	  (module       (modules-initialisation))
	  (procedure    (read-procedure-initialisation))
	  (require      (declare-global-variable! 'require-initialisation?
						  *module-name*
						  'static))
	  (new-body     `(cif ,(abstract-bbool->cbool require)
			      (begin
				 (set! ,require ,(abstract-false))
				 ,@(append module
					   cnst
					   procedure)
				 ,old-body)
			      ,(abstract-unspecified))))
      (function-body-set! (global-value var) new-body)))
