;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../read-exp.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 14:18:09 1993                          */
;*    Last change :  Fri Nov 26 16:00:24 1993 (serrano)                */
;*                                                                     */
;*    L'allocation des constantes                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_read_expression
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  heap_abstract
	    engine_param
	    cnst_read_alloc
	    cnst_module
	    tools_shape
	    tools_speek
	    tools_error)
   (export  (read-cnst exp link?)))

;*---------------------------------------------------------------------*/
;*    cnst ...                                                         */
;*---------------------------------------------------------------------*/
(define (read-cnst exp link?)
   (trace cnst "exp: " (shape exp) #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       exp)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (if (global? exp)
	   (if (not (eq? (global-class exp) 'foreign))
	       (remember-module! (global-module exp))))
       exp)
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (set-car! (cddr exp) (read-cnst (caddr exp) #t))
       exp)
;*--- function --------------------------------------------------------*/
      (((or function function-light) ?var)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       (read-cnst-quote (cadr exp)))
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (set-car! (cdr exp) (read-cnst (cadr exp) #f))
       (set-car! (cddr exp) (read-cnst (caddr exp) #f))
       (set-car! (cdddr exp) (read-cnst (cadddr exp) #f))
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (read-cnst (cadr exp) #f))
       (if (boolean? (cadr exp))
	   (if (cadr exp)
	       (read-cnst (caddr exp) link?)
	       (read-cnst (cadddr exp) link?))
	   (begin
	      (set-car! (cddr exp) (read-cnst (caddr exp) link?))
	      (set-car! (cdddr exp) (read-cnst (cadddr exp) link?))
	      exp)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (set-car! (cddr exp) (read-cnst test #f))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (read-cnst (cadr (car hook)) link?))
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (read-cnst (car hook) link?))
		 exp)
	      (begin
		 (set-car! hook (read-cnst (car hook) #f))
		 (loop (cdr hook))))))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (let loop ((hook (cadr exp)))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (read-cnst (caddr exp) link?))
		 exp)
	      (begin
		 (set-car! (cdar hook)
			   (read-cnst (cadr (car hook)) #f))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels . ?-)
       (let loop ((hook (cadr exp)))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (read-cnst (caddr exp) link?))
		 exp)
	      (begin
		 (set-car! (cddar hook)
			   (read-cnst (caddr (car hook)) #f))
		 (function-body-set! (local-value (car (car hook)))
				     (caddar hook))
		 (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (set-car! (cddr exp) (read-cnst (caddr exp) #f))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (set-car! (cddr exp) (read-cnst (caddr exp) #f))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply . ?-)
       (let liip ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (read-cnst (car hook) #f))
		 (liip (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
      (((or funcall funcall-light) . ?-)
       (let liip ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (read-cnst (car hook) #f))
		 (liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
      (else
       (read-cnst-application exp link?))))

;*---------------------------------------------------------------------*/
;*    cnst-quote ...                                                   */
;*---------------------------------------------------------------------*/
(define (read-cnst-quote exp)
   (trace cnst "cnst-quote: " (shape exp) #\Newline)
   (cond
      ((null? exp)
       (abstract-nil))
      ((symbol? exp)
       (read-cnst-alloc-symbol exp))
      ((string? exp)
       (read-cnst-alloc-string exp))
      ((char? exp)
       (abstract-cchar->bchar exp))
      ((boolean? exp)
       (abstract-cbool->bbool exp))
      ((integer? exp)
       (abstract-cint->bint exp))
      ((real? exp)
       (abstract-cdouble->breal exp))
      ((pair? exp)
       (read-cnst-alloc-list exp))
      ((vector? exp)
       (read-cnst-alloc-vector exp))))

;*---------------------------------------------------------------------*/
;*    cnst-application ...                                             */
;*---------------------------------------------------------------------*/
(define (read-cnst-application exp link?)
   ;; on cnst tous les arguments
   (let liip ((hook exp))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (read-cnst (car hook) #f))
		    (liip (cdr hook)))))
   ;; on reconnait les cas triviaux.
   (let ((fun (car exp)))
      (cond
	 ((and (abstract-cstring->bstring? fun)
	       (string? (cadr exp)))
	  (read-cnst-alloc-string (cadr exp)))
	 ((and (abstract-csymbol->bsymbol? fun)
	       (symbol? (cadr exp)))
	  (read-cnst-alloc-symbol (cadr exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (boolean? (cadr exp)))
	  (if (cadr exp)
	      (abstract-true)
	      (abstract-false)))
	 ((and (or (abstract-make-fx-procedure? fun)
		   (abstract-make-va-procedure? fun))
	       (=fx (cadddr exp) 0))
	  (read-cnst-alloc-procedure exp link?))
	 ((and (abstract-make-light-procedure? fun)
	       (=fx (caddr exp) 0))
	  (read-cnst-alloc-procedure exp link?))
	 ((and (abstract-bbool->cbool? fun)
	       (pair? (cadr exp))
	       (abstract-cbool->bbool? (car (cadr exp))))
	  (read-cnst (cadr (cadr exp)) #f))
	 ((abstract-bbool->cbool? fun)
	  (cond
	     ((abstract-true? (cadr exp))
	      #t)
	     ((abstract-false? (cadr exp))
	      #f)
	     (else
	      exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (pair? (cadr exp))
	       (abstract-bbool->cbool? (car (cadr exp))))
	  (read-cnst (cadr (cadr exp)) #f))
	 ((and (abstract-not? fun)
	       (pair? (cadr exp))
	       (abstract-not? (car (cadr exp))))
	  (read-cnst (cadr (cadr exp)) #f))
	 ((and (abstract-cint->bint? fun)
	       (pair? (cadr exp))
	       (abstract-bint->cint? (car (cadr exp))))
	  (read-cnst (cadr (cadr exp)) #f))
	 ((and (abstract-bint->cint? fun)
	       (pair? (cadr exp))
	       (abstract-cint->bint? (car (cadr exp))))
	  (read-cnst (cadr (cadr exp)) #f))
	 (else
	  exp))))

;*---------------------------------------------------------------------*/
;*    failure? ...                                                     */
;*---------------------------------------------------------------------*/
(define (failure? exp)
   (match-case exp
      ((failure ?- ?- ?-)
       #t)
      (else
       #f)))
