;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Assert/make.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 10 15:43:17 1993                          */
;*    Last change :  Tue Nov 16 13:09:59 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On pose les assertions ...                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_make
   (include "Assert/assert.sch"
	    "Var/variable.sch"
	    "Tools/trace.sch"
	    "Foreign/type.sch")
   (import   scan_lexical
	     heap_abstract
	     assert_get
	     tools_shape)
   (export   (make-function-assertions! var body)
	     (make-variable-assertion var exp)
	     (make-one-assert assert body)))

;*---------------------------------------------------------------------*/
;*    make-function-assertions! ...                                    */
;*---------------------------------------------------------------------*/
(define (make-function-assertions! var body)
   (trace assert "make-function-assertions: " (shape var) #\Newline)
   (let ((info  (if (local? var)
		    (local-info var)
		    (global-info var)))
	 (value (if (local? var)
		    (local-value var)
		    (global-value var))))
      (if (not (assert? info))
	  (make-formals-assert (function-args value) body)
	  (make-formals-assert
	   (function-args value)
	   (make-beginning-assert
	    (assert-beginning info)
	    (make-end-assert (assert-end info) body))))))

;*---------------------------------------------------------------------*/
;*    make-formals-assert ...                                          */
;*---------------------------------------------------------------------*/
(define (make-formals-assert formals body)
   (let loop ((formals formals)
	      (body    body))
      (if (null? formals)
	  body
	  (if (asserted-variable? (car formals))
	      (loop (cdr formals)
		    (make-variable-assertion (car formals) body))
	      (loop (cdr formals)
		    body)))))

;*---------------------------------------------------------------------*/
;*    make-beginning-assert ...                                        */
;*---------------------------------------------------------------------*/
(define (make-beginning-assert asserts body)
   (trace assert "make-beginning-assert: " (shape asserts) #\Newline)
   (let loop ((asserts asserts)
	      (body    body))
      (if (null? asserts)
	  body
	  (loop (cdr asserts)
		(make-one-assert (car asserts) body)))))

;*---------------------------------------------------------------------*/
;*    make-end-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-end-assert asserts body)
   (trace assert "make-end-assert: " (shape asserts) #\Newline)
   (if (null? asserts)
       body
       (let loop ((asserts asserts)
		  (body    body))
	  (if (null? asserts)
	      body
	      (loop (cdr asserts)
		    (make-one-assert (car asserts) body))))))

;*---------------------------------------------------------------------*/
;*    make-one-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-one-assert assert body)
   (trace assert "make-one-assert: " (shape assert) #\Newline)
   (let ((scope   (cadr assert))
	 (formals (caddr assert))
	 (pred    (copy-pred (cadddr assert)))
	 (l       (allocate-local-variable 'l)))
      `(begin
	  ;; on test l'assertion
	  (cif ,pred
	       'ok
	       (begin
		  ;; on declare les variables `assertees' a l'interprete
		  ,@(let loop ((formals formals)
			       (defs    '()))
		       (if (null? formals)
			   defs
			   (loop (cdr formals)
				 (cons (abstract
					'define-primop-ref!
					`',(assert-shape (car formals))
					(abstract 'location (car formals)))
				       defs))))
		  ;; on notify que l'assertion a echoue.
		  ,(abstract 'notify-assert-fail
			     `',scope
			     `',(map assert-shape formals)
			     (let loop ((f formals))
				(if (null? f)
				    (abstract-nil)
				    (abstract 'c-cons
					      (car f)
					      (loop (cdr f)))))
			     `',(assert-shape pred))
		  ;; on supprime les variables
		  ,@(let loop ((formals formals)
			       (defs    '()))
		       (if (null? formals)
			   defs
			   (loop (cdr formals)
				 (cons (abstract
					'__unbound!
					`',(assert-shape (car formals)))
				       defs)))))) 
	  ,body)))

;*---------------------------------------------------------------------*/
;*    copy-pred ...                                                    */
;*---------------------------------------------------------------------*/
(define (copy-pred l)
   (reverse! (reverse l)))
   
;*---------------------------------------------------------------------*/
;*    assert-shape ...                                                 */
;*---------------------------------------------------------------------*/
(define (assert-shape exp)
  (cond
      ((global? exp)
       (global-name exp))
      ((local? exp)
       (local-name exp))
      ((type? exp)
       (type-id exp))
      ((not (pair? exp))
       exp)
      ((vector? exp)
       (let* ((len (vector-length exp))
	      (res (make-vector len)))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (vector-set! res
				 indice
				 (assert-shape (vector-ref exp indice)))
		    (loop (+fx indice 1)))))))
      (else
       (let loop ((exp exp))
	  (cond
	     ((null? exp)
	      '())
	     ((not (pair? exp))
	      (assert-shape exp))
	     (else
	      (cons (assert-shape (car exp)) (loop (cdr exp)))))))))
   
;*---------------------------------------------------------------------*/
;*    make-variable-assertion ...                                      */
;*---------------------------------------------------------------------*/
(define (make-variable-assertion var exp)
   (let ((info   (if (local? var)
		     (local-info var)
		     (global-info var))))
      (let loop ((asserts (assert-always info))
		 (body    exp))
	 (if (null? asserts)
	     body
	     (loop (cdr asserts)
		   (make-one-assert (car asserts) body))))))
