;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Assert/get.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 10 11:24:48 1993                          */
;*    Last change :  Mon Nov 15 11:25:11 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On collecte les assertions qu'on trouve dans les corps           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_get
   (include "Assert/assert.sch"
	    "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_shape)
   (export  (get-assertions! exp parent)
	    (asserted-variable? var)))

;*---------------------------------------------------------------------*/
;*    get-assertions! ...                                              */
;*---------------------------------------------------------------------*/
(define (get-assertions! exp parent)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       'done)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       'done)
;*--- assert ----------------------------------------------------------*/
      ((assert . ?-)
       (declare-assertion! exp parent))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      'done
	      (begin
		 (get-assertions! (car hook) parent)
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (get-assertions! val parent))
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (get-assertions! body parent)
	      (begin
		 (get-assertions! (cdar hook) parent)
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (get-assertions! body parent)
	      (begin
		 (get-assertions! (caddr (car hook)) (car (car hook)))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (get-assertions! proc parent)
       (get-assertions! msg parent)
       (get-assertions! obj parent))
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit ?- ?body)
       (get-assertions! body parent))
;*--- apply -----------------------------------------------------------*/
      ((apply ?fun ?val)
       (get-assertions! fun parent)
       (get-assertions! val parent))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (get-assertions! test parent)
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (get-assertions! (cdr (car hook)) parent)
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (get-assertions! si parent)
       (get-assertions! alors parent)
       (get-assertions! sinon parent))
;*--- application -----------------------------------------------------*/
      (else
       (let loop ((exp exp))
	  (if (null? exp)
	      'done
	      (begin
		 (get-assertions! (car exp) parent)
		 (loop (cdr exp))))))))

;*---------------------------------------------------------------------*/
;*    declare-assertion! ...                                           */
;*---------------------------------------------------------------------*/
(define (declare-assertion! exp parent)
   (trace assert "declare-assertion!: " (shape exp) " " (shape parent)
	  #\Newline)
   (match-case exp
      ((?- check . ?-)
       exp)
      ((?- always ?formals ?-)
       (for-each (lambda (f)
		    (add-assert! exp f))
		 formals)
       #f)
      ((?- (or beginning end) ?formals ?-)
       (add-assert! exp parent)
       #f)))

;*---------------------------------------------------------------------*/
;*    add-assert! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-assert! exp f)
   (trace assert "add-assert!: " (shape exp) " " (shape f)
	  #\Newline)
   (define (add-info-assert! info)
      (case (cadr exp)
	 ((always)
	  (assert-always-set! info (cons exp (assert-always info))))
	 ((beginning)
	  (assert-beginning-set! info (cons exp (assert-beginning info))))
	 ((end)
	  (assert-end-set! info (cons exp (assert-end info))))))
   (cond
      ((global? f)
       (if (not (assert? (global-info f)))
	   (global-info-set! f (make-assert)))
       (add-info-assert! (global-info f)))
      ((local? f)
       (if (not (assert? (local-info f)))
	   (local-info-set! f (make-assert)))
       (add-info-assert! (local-info f)))))

;*---------------------------------------------------------------------*/
;*    asserted-variable? ...                                           */
;*---------------------------------------------------------------------*/
(define (asserted-variable? var)
   (assert? (if (local? var)
		(local-info var)
		(global-info var))))
			    
