;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../atomic.scm ...                                               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Oct 20 08:51:15 1993                          */
;*    Last change :  Mon May 16 17:16:34 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les types atomiques (pre-existants)                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_atomic
   (include "Foreign/type.sch")
   (import  foreign_tools
	    foreign_parse
	    foreign_cast
	    type_type
	    heap_abstract
	    scan_lexical
	    type_enforce)
   (export  *bobj*
	    *bint*
	    *breal*
	    *bbool*
	    *bpair*
	    *bstring*
	    *bchar*
	    *bprocedure*
	    *breturn*
	    *bsymbol*
	    *bvector*
	    *bstruct*
	    *binput-port*
	    *boutput-port*
	    *bcameleon*
	    *bnil*
	    *bforeign*
	    *foreign*
	    *long*
	    *char*
	    *string*
	    *bool*
	    *void*
	    *double*
	    *function*
	    *jmp-buf*
	    (define-atomic-type!)
	    (make-atomic-casting!)))

;*---------------------------------------------------------------------*/
;*    Tous les types predefinis                                        */
;*---------------------------------------------------------------------*/
(define *bobj*         (unspecified))
(define *bint*         (unspecified))
(define *breal*        (unspecified))
(define *bbool*        (unspecified))
(define *bpair*        (unspecified))
(define *bstring*      (unspecified))
(define *bchar*        (unspecified))
(define *bprocedure*   (unspecified))
(define *breturn*      (unspecified))
(define *bsymbol*      (unspecified))
(define *bvector*      (unspecified))
(define *bstruct*      (unspecified))
(define *binput-port*  (unspecified))
(define *boutput-port* (unspecified))
(define *bcameleon*    (unspecified))
(define *bnil*         (unspecified))
(define *bforeign*     (unspecified))
(define *foreign*      (unspecified))
(define *int*          (unspecified))
(define *uint*         (unspecified))
(define *long*         (unspecified))
(define *ulong*        (unspecified))
(define *short*        (unspecified))
(define *ushort*       (unspecified))
(define *char*         (unspecified))
(define *uchar*         (unspecified))
(define *string*       (unspecified))
(define *bool*         (unspecified))
(define *void*         (unspecified))
(define *double*       (unspecified))
(define *function*     (unspecified))
(define *jmp-buf*      (unspecified))
(define *file*         (unspecified))

;*---------------------------------------------------------------------*/
;*    define-atomic-type! ...                                          */
;*    -------------------------------------------------------------    */
;*    Dans cette fonction, on place les noms des procedures et des     */
;*    types plutot que les objets eux-meme. Dans la passe, `end',      */
;*    on changera cela.                                                */
;*---------------------------------------------------------------------*/
(define (define-atomic-type!)
   ;; Les types C initiaux
   ;; -----------------------------------------------------------------*/
   ;; les types etrangers
   (set! *foreign*   (define-type 'foreign "void *" 'c-atom 'foreign))
   ;; les entiers C
   (set! *int*       (define-subtype (list *foreign*) 'int "int"
			'c-atom 'int))
   (set! *uint*      (define-subtype (list *foreign*) 'uint "unsigned int"
			'c-atom 'uint))
   (set! *long*      (define-subtype (list *foreign*) 'long "long"
			'c-atom 'long))
   (set! *ulong*     (define-subtype (list *foreign*) 'ulong "unsigned long"
			'c-atom 'ulong))
   (set! *short*     (define-subtype (list *foreign*) 'short "short"
			'c-atom 'short))
   (set! *ushort*    (define-subtype (list *foreign*) 'ushort "unsigned short"
			'c-atom 'ushort))
   ;; les caracteres C
   (set! *char*      (define-subtype (list *foreign*) 'char "char"
			'c-atom 'char))
   (set! *uchar*      (define-subtype (list *foreign*) 'uchar "unsigned char"
			'c-atom 'uchar))
   ;; les chaines C
   (set! *string*    (define-subtype (list *foreign*) 'string "char *"
			'c-atom 'string))
   ;; les boolens C
   (set! *bool*      (define-subtype (list *foreign*) 'bool "bool_t"
			'c-atom 'bool))
   ;; void
   (set! *void*      (define-subtype (list *foreign*) 'void "void"
			'c-atom 'void))
   ;; les doubles
   (set! *double*    (define-subtype (list *foreign*) 'double "double"
			'c-atom 'double))
   ;; les fonctions C
   (set! *function*  (define-subtype (list *foreign*) 'function "function_t"
			'c-atom 'function))
   ;; les jmp-buf dont on a besoin dans les dernieres passes de la compile
   (set! *jmp-buf*   (define-subtype (list *foreign*) 'jmp-buf "jmp_buf"
			'c-atom 'jmp-buf))
   ;; les file*
   (set! *file*      (define-subtype (list *foreign*) 'file "FILE *"
			'c-atom 'file))
   ;; Les types Bigloo
   ;; -----------------------------------------------------------------*/
   ;; le type generique
   (set! *bobj*      (define-type 'bobj "obj_t"	'bigloo-atom 'bobj))
   ;; les entiers Bigloo
   (set! *bint*      (define-subtype (list *bobj*) 'bint "obj_t"
			'bigloo-atom 'bint))
   ;; les reels
   (set! *breal*     (define-subtype (list *bobj*) 'breal "obj_t"
			'bigloo-atom 'breal))
   ;; les boolens
   (set! *bbool*     (define-subtype (list *bobj*) 'bbool "obj_t"
			'bigloo-atom 'bbool))
   ;; les pairs
   (set! *bpair*     (define-subtype (list *bobj*) 'bpair "obj_t"
			'bigloo-atom 'bpair))
   ;; les chaines
   (set! *bstring*   (define-subtype (list *bobj*) 'bstring "obj_t"
			'bigloo-atom 'bstring))
   ;; les chars
   (set! *bchar*     (define-subtype (list *bobj*) 'bchar "obj_t"
			'bigloo-atom 'bchar))
   ;; les procedures
   (set! *bprocedure* (define-subtype (list *bobj*) 'bprocedure "obj_t"
			 'bigloo-atom 'bprocedure))
   ;; les returns
   (set! *breturn*   (define-subtype (list *bobj*) 'breturn "obj_t"
			'bigloo-atom 'bprocedure))
   ;; les symbols
   (set! *bsymbol*   (define-subtype (list *bobj*) 'bsymbol "obj_t"
			'bigloo-atom 'bsymbol))
   ;; les vecteurs
   (set! *bvector*   (define-subtype (list *bobj*) 'bvector "obj_t"
			'bigloo-atom 'bvector))
   ;; les structures
   (set! *bstruct*   (define-subtype (list *bobj*) 'bstruct "obj_t"
			'bigloo-atom 'bstruct))
   ;; les ports
   (set! *binput-port* (define-subtype (list *bobj*) 'binput-port "obj_t"
			  'bigloo-atom 'binput-port))
   (set! *boutput-port* (define-subtype (list *bobj*) 'boutput-port "obj_t"
			  'bigloo-atom 'boutput-port))
   ;; le type cameleon
   (set! *bcameleon* (define-subtype (list *bobj*) 'bcameleon "obj_t"
			'bigloo-atom 'bcameleon))
   ;; nil
   (set! *bnil*      (define-subtype (list *bobj*) 'nil "obj_t"
			'bigloo-atom 'nil))
   ;; foreign
   (set! *bforeign*  (define-subtype (list *bobj*) 'bforeign "obj_t"
			'bigloo-atom 'bforeign))
   ;; Les alias pour ne pas avoir de pbm avec le tas et les vieux Bigloo
   ;; -----------------------------------------------------------------*/
   (parse-type '(type char*     string))
   (parse-type '(type obj       bobj))
   (parse-type '(type cint      int))
   (parse-type '(type cchar     char))
   (parse-type '(type cstring   string))
   (parse-type '(type cbool     bool))
   (parse-type '(type cvoid     void))
   (parse-type '(type cdouble   double))
   (parse-type '(type cfunction function))
   (parse-type '(type cjmp-buf  jmp-buf)))

;*---------------------------------------------------------------------*/
;*    I ...                                                            */
;*---------------------------------------------------------------------*/
(define (I x) x)

;*---------------------------------------------------------------------*/
;*    abstract-enforcer ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-enforcer fun-name type-name)
   (enforcer (lambda (x) (abstract fun-name x))
	     type-name))

;*---------------------------------------------------------------------*/
;*    make-atomic-casting! ...                                         */
;*    -------------------------------------------------------------    */
;*    Cette fonction est appelle, une fois que l'arbre a ete           */
;*    construit, on possede donc des images des objets runtime.        */
;*---------------------------------------------------------------------*/
(define (make-atomic-casting!)
   ;;
   ;; La hierarchie C
   ;; -----------------------------------------------------------------*/
   ;; <-> booleen
   (allow-cast! *int*  *bool* I (lambda (x) #t))
   (allow-cast! *uint*  *bool* I (lambda (x) #t))
   (allow-cast! *long*  *bool* I (lambda (x) #t))
   (allow-cast! *ulong*  *bool* I (lambda (x) #t))
   (allow-cast! *short*  *bool* I (lambda (x) #t))
   (allow-cast! *ushort*  *bool* I (lambda (x) #t))
   (allow-cast! *char*  *bool* I (lambda (x) #t))
   (allow-cast! *uchar*  *bool* I (lambda (x) #t))
   (allow-cast! *string*  *bool* I (lambda (x) #t))
   (allow-cast! *double* *bool* I (lambda (x) #t))
   (allow-cast! *bool* *int*  I I)
   (allow-cast! *bool* *uint*  I I)
   (allow-cast! *bool* *long*  I I)
   (allow-cast! *bool* *ulong*  I I)
   (allow-cast! *bool* *short*  I I)
   (allow-cast! *bool* *ushort*  I I)
   (allow-cast! *bool* *char*  I I)
   (allow-cast! *bool* *uchar*  I I)
   ;; <-> int et long
   (allow-cast! *long* *int* I I)
   (allow-cast! *int* *long* I I)
   ;; <-> foreign
   (allow-cast! *foreign* *int* I I)
   (allow-cast! *foreign* *uint* I I)
   (allow-cast! *foreign* *long* I I)
   (allow-cast! *foreign* *ulong* I I)
   (allow-cast! *foreign* *short* I I)
   (allow-cast! *foreign* *ushort* I I)
   (allow-cast! *foreign* *char* I I)
   (allow-cast! *foreign* *uchar* I I)
   (allow-cast! *foreign* *string* I I)
   (allow-cast! *foreign* *bool* I I)
   (allow-cast! *foreign* *double* I I)
   (allow-cast! *foreign* *void* I I)
   (allow-cast! *foreign* *file* I I)
   (allow-cast! *int* *foreign* I I)
   (allow-cast! *uint* *foreign* I I)
   (allow-cast! *long* *foreign* I I)
   (allow-cast! *ulong* *foreign* I I)
   (allow-cast! *short* *foreign* I I)
   (allow-cast! *ushort* *foreign* I I)
   (allow-cast! *char* *foreign* I I)
   (allow-cast! *uchar* *foreign* I I)
   (allow-cast! *string* *foreign* I I)
   (allow-cast! *bool* *foreign* I I)
   (allow-cast! *double* *foreign* I I)
   (allow-cast! *void* *foreign* I I)
   (allow-cast! *file* *foreign* I I)
   ;;
   ;; La hierarchie Bigloo
   ;; -----------------------------------------------------------------*/
   ;; les entiers
   (allow-cast! *bobj* *bint* (abstract-enforcer 'c-integer? 'number) I)
   (allow-cast! *bint* *bobj* I I)
   ;; les reals
   (allow-cast! *bobj* *breal* (abstract-enforcer 'c-real? 'real) I)
   (allow-cast! *breal* *bobj* I I)
   ;; les entiers/reels
   (allow-cast! *bint* *breal*
		I (lambda (x) (abstract 'c-fixnum->flonum x)))
   (allow-cast! *breal* *bint*
		I (lambda (x) (abstract 'c-flonum->fixnum x)))
   ;; les booleens
   (allow-cast! *bobj* *bbool* (abstract-enforcer 'c-boolean? 'bool) I)
   (allow-cast! *bbool* *bobj* I I)
   (allow-cast! *bobj* *bool* I (lambda (x) (abstract 'c-bbool->cbool x)))
   ;; les pairs
   (allow-cast! *bobj* *bpair* (abstract-enforcer 'c-pair? 'pair) I)
   (allow-cast! *bpair* *bobj* I I)
   ;; les strings
   (allow-cast! *bobj* *bstring* (abstract-enforcer 'c-string? 'string) I)
   (allow-cast! *bstring* *bobj* I I)
   ;; les chars
   (allow-cast! *bobj* *bchar* (abstract-enforcer 'c-char? 'char) I)
   (allow-cast! *bchar* *bobj* I I)
   ;; les procedures
   (allow-cast! *bobj* *bprocedure*
		(abstract-enforcer 'c-procedure? 'procedure) I)
   (allow-cast! *bprocedure* *bobj* (lambda (x) `(function ,x)) I)
   ;; les returns
   (allow-cast! *bobj* *breturn* (abstract-enforcer 'c-return? 'return) I)
   (allow-cast! *breturn* *bobj* I I)
   ;; les symbols
   (allow-cast! *bobj* *bsymbol* (abstract-enforcer 'c-symbol? 'symbol) I)
   (allow-cast! *bsymbol* *bobj* I I)
   ;; les output-ports
   (allow-cast! *bobj* *boutput-port*
		(abstract-enforcer 'c-output-port? 'output-port) I)
   (allow-cast! *boutput-port* *bobj* I I)
   ;; les input-ports
   (allow-cast! *bobj* *binput-port*
		(abstract-enforcer 'c-input-port? 'input-port) I)
   (allow-cast! *binput-port* *bobj* I I)
   ;; foreign
   (allow-cast! *bobj* *bforeign*
		(abstract-enforcer 'c-foreign? 'foreign) I)
   (allow-cast! *bforeign* *bobj* I I)
   ;; les structures
   (allow-cast! *bobj* *bstruct* (abstract-enforcer 'c-struct? 'struct) I)
   (allow-cast! *bstruct* *bobj* I I)
   ;; les vecteurs
   (allow-cast! *bobj* *bvector* (abstract-enforcer 'c-vector? 'vector) I)
   (allow-cast! *bvector* *bobj* I I)
   ;; nil
   (allow-cast! *bobj* *bnil* I I)
   (allow-cast! *bnil* *bobj* I I)
   ;; 
   ;; Les Cast entre types Bigloo et types C
   ;; -----------------------------------------------------------------*/
   ;; les entiers/entiers
   (allow-cast! *int* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *int* I (lambda (x) (abstract 'c-bint->cint x)))
   (allow-cast! *uint* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *uint* I (lambda (x) (abstract 'c-bint->cint x)))
   (allow-cast! *long* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *long* I (lambda (x) (abstract 'c-bint->cint x)))
   (allow-cast! *ulong* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *ulong* I (lambda (x) (abstract 'c-bint->cint x)))
   (allow-cast! *short* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *short* I (lambda (x) (abstract 'c-bint->cint x)))
   (allow-cast! *ushort* *bint* I (lambda (x) (abstract 'c-cint->bint x)))
   (allow-cast! *bint* *ushort* I (lambda (x) (abstract 'c-bint->cint x)))
   ;; les entiers/reals
   (allow-cast! *int* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *uint* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *long* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *ulong* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *short* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *ushort* *breal* I (lambda (x) (abstract 'c-cdouble->breal x)))
   ;; les caracteres/caracters
   (allow-cast! *char* *bchar* I (lambda (x) (abstract 'c-cchar->bchar x)))
   (allow-cast! *bchar* *char* I (lambda (x) (abstract 'c-bchar->cchar x)))
   (allow-cast! *uchar* *bchar* I (lambda (x) (abstract 'c-cchar->bchar x)))
   (allow-cast! *bchar* *uchar* I (lambda (x) (abstract 'c-bchar->cchar x)))
   ;; les chaines/chaine
   (allow-cast! *string* *bstring*
		I (lambda (x) (abstract 'c-cstring->bstring x)))
   (allow-cast! *bstring* *string*
		I (lambda (x) (abstract 'c-bstring->cstring x)))
   ;; les booleens/booleens
   (allow-cast! *bool* *bbool* I (lambda (x) (abstract 'c-cbool->bbool x)))
   (allow-cast! *bbool* *bool* I (lambda (x) (abstract 'c-bbool->cbool x)))
   ;; les void
;*    (allow-cast! *void* *bobj* I (lambda (x) (abstract 'c-void->bvoid x))) */
   (allow-cast! *void* *bobj* I (lambda (x) `(begin
						,x
						,(abstract-unspecified))))
   ;; les doubles/doubles
   (allow-cast! *double* *breal*
		I (lambda (x) (abstract 'c-cdouble->breal x)))
   (allow-cast! *breal* *double*
		I (lambda (x) (abstract 'c-breal->cdouble x)))
   ;; les foreign
   (allow-cast! *foreign* *bforeign* I (lambda (x)
					  (let ((type (type-of x)))
					     (abstract 'c-cforeign->bforeign
						       (type-id type)
						       x))))
   (allow-cast! *bforeign* *foreign*
		I (lambda (x) (abstract 'c-bforeign->cforeign x)))
   (allow-cast! *bobj* *foreign* I (lambda (x) (abstract 'c-bobj->cforeign x)))
   ;; les files/output-port
   (allow-cast! *file* *boutput-port*
		I (lambda (x) (abstract 'c-cfile->boutput-port x)))
   (allow-cast! *boutput-port* *file*
		I (lambda (x) (abstract 'c-boutput-port->cfile x))))

		  
   

   
   


