;;; stack machine,  taking input from a stream

;;; stack = value*

;;; action = stack -> ans

;;; halt, returning top of stack

(define halt-instruction
  (lambda ()
    (lambda (stack)
      (car stack))))


;;; instruction = action -> action

(define incr-instruction
  (lambda (action)
    (lambda (stack)
      (action (cons (+ (car stack) 1)
                    (cdr stack))))))

;; read a value from the input stream and put it on the stack:

(define read-instruction
  (lambda (action)
    (lambda (stack)
      (let ((val (prompt-read "machine>")))
        (action (cons val stack))))))

(define prompt-read
  (lambda (prompt)
    (printf "~d " prompt)
    (read)))

(define start
  (lambda (action)
    (action '())))

(define test1
  (lambda ()
    (start (read-instruction (incr-instruction (halt-instruction))))))

(define push-instruction
  (lambda (v action)
    (lambda (stack)
      (action
        (cons v stack)))))

(define add-instruction
  (lambda (action)
    (lambda (stack)
      (action 
        (cons
          (+ (car stack) (cadr stack))
          (cddr stack))))))

(define zero?-instruction
  (lambda (true-action false-action)
    (lambda (stack)
      (if (zero? (car stack))
        (true-action stack)
        (false-action stack)))))

