;;;This is the file CDATA.SCM
;;;This initializes the data base for problem set 9
;;;This file should not be loaded into Scheme until after the query
;;;system has been loaded.
;;;To add new rules or assertions to the data base, edit the definition
;;;of COURSE-DATA-BASE and zap this file into Scheme.  BE SURE TO EXIT
;;;THE QUERY DRIVER LOOP BEFORE ZAPPING THE FILE!

(define course-data-base
  '(
    (meets 6:001 tuesday 10:00)
    (meets 6:001 thursday 10:00)
    (units 6:001 15)

    (meets 6:002 tuesday 11:00)
    (meets 6:002 thursday 11:00)
    (units 6:002 15)
    (has-prerequisite 6:002 18:03)

    (meets 6:003 tuesday 12:00)
    (meets 6:003 thursday 12:00)
    (units 6:003 15)
    (has-prerequisite 6:003 6:002)
    (has-prerequisite 6:003 6:001)

    (meets 18:01 tuesday 1:00)
    (meets 18:01 thursday 1:00)
    (meets 18:01 friday 2:00)
    (units 18:01 12)

    (meets 18:02 tuesday 1:00)
    (meets 18:02 thursday 1:00)
    (meets 18:02 friday 2:00)
    (units 18:02 12)
    (has-prerequisite 18:02 18:01)

    (meets 18:03 monday 1:00)
    (meets 18:03 wednesday 1:00)
    (meets 18:03 friday 1:00)
    (units 18:03 12)
    (has-prerequisite 18:03 18:02)

    (has-credit hal 6:001)
    (has-credit hal 18:01)

    ;;rules for the course data base

    (rule (same ?x ?x))

    ;;do two courses meet at the same time and day?
    (rule (conflicts ?x ?y)
	  (and (meets ?x ?day ?time)
	       (meets ?y ?day ?time)
	       (not (same ?x ?y))))

    ;;is course ?x in the prerequisite chain for course ?y

    (rule (is-in-prerequisite-chain ?x ?y)
	  (or (has-prerequisite ?y ?x)
	      (and (has-prerequisite ?y ?subject)
		   (is-in-prerequisite-chain ?x ?subject))))

    ;;must ?person take ?prereq before s/he can take ?subject

    (rule (must-take-first-for ?person ?prereq ?subject)
	  (and (is-in-prerequisite-chain ?prereq ?subject)
	       (not (has-credit ?person ?prereq))))

    ))

(initialize-data-base course-data-base)

