;;; 6.001 -- Fall93
;;; These are a set of useful but uninteresting definitions
;;; that are helpful in many calculations.

(define (compose f g)
  (lambda (x)
    (f (g x))))

(define (identity x) x)

(define (repeated f n)
  (cond ((= n 0) identity)
        ((= n 1) f)
        (else (compose f (repeated f (- n 1))))))


;;; Some useful angles are named below:

(define pi (* 4 (atan 1 1)))
(define +pi pi)
(define -pi (- pi))

;;; Some useful numerical procedures

(define log10
  (let ((l10 (log 10)))
    (lambda (x)
      (/ (log x) l10))))

(define (exp10 x)
  (expt 10 x))

(define (square x) (* x x))
(define (cube x) (* x x x))

(define (negate x) (- x))
(define (invert x) (/ x))

(define (sec x) (/ 1 (cos x)))
(define (csc x) (/ 1 (sin x)))

(define (cosh x)
  (/ (+ (exp x) (exp (- x))) 2))
(define (sinh x)
  (/ (- (exp x) (exp (- x))) 2))


