
;;; Sets

(define (union-set s1 s2)
  (cond ((null? s1) s2)
        ((memq (car s1) s2) (union-set (cdr s1) s2))
        (else (cons (car s1) (union-set (cdr s1) s2)))))

(define (difference-set s1 s2)
  (cond ((null? s1) empty-set)
        ((memq (car s1) s2) (difference-set (cdr s1) s2))
        (else (cons (car s1) (difference-set (cdr s1) s2)))))

(define (element-of-set? x s) (memq x s))

(define (singleton x) (list x))

(define (make-set list-of-elements) list-of-elements)

(define empty-set '())

;;; Instructions and instruction sequences

(define (make-instruction-sequence needed modified statements)
  (list needed modified statements))

(define (empty-instruction-sequence)
  (make-instruction-sequence empty-set empty-set '()))

(define (append-instruction-sequences . seqs)
  (define (append-2-sequences seq1 seq2)
    (make-instruction-sequence
     (union-set (registers-needed seq1)
                (difference-set (registers-needed seq2)
                                (registers-modified seq1)))
     (union-set (registers-modified seq1)
                (registers-modified seq2))
     (append (statements seq1) (statements seq2))))
  (define (append-seq-list seqs)
    (if (null? seqs)
        (empty-instruction-sequence)
        (append-2-sequences (car seqs)
                            (append-seq-list (cdr seqs)))))
  (append-seq-list seqs))

(define (preserving regs seq1 seq2)
  (cond ((null? regs)
	 (append-instruction-sequences seq1 seq2))
	(else
	 (let ((first-reg (car regs)))
	   (if (and (needs-register? seq2 first-reg)
		    (modifies-register? seq1 first-reg))
	       (preserving (cdr regs)
			   (make-instruction-sequence
			    (union-set (singleton first-reg) (registers-needed seq1))
			    (difference-set (registers-modified seq1)
					    (singleton first-reg))
			    `((save ,first-reg)
			      ,@(statements seq1)
			      (restore ,first-reg)))
			   seq2)
	       (preserving (cdr regs)
			   seq1
			   seq2))))))


(define (tack-on-instruction-sequence seq body-seq)
  (append-instruction-sequences
   seq
   (make-instruction-sequence empty-set
                              empty-set
                              (statements body-seq))))

(define (parallel-instruction-sequences seq1 seq2)
  (make-instruction-sequence
   (union-set (registers-needed seq1) (registers-needed seq2))
   (union-set (registers-modified seq1) (registers-modified seq2))
   (append (statements seq1) (statements seq2))))


;;; arg1 arg2 ... registers reserved for passing arguments.

(define all-regs (make-set '(env proc val argl continue arg1 arg2)))



(define (registers-needed s)
  (if (symbol? s) empty-set (car s)))
(define (registers-modified s)
  (if (symbol? s) empty-set (cadr s)))
(define (statements s)
  (if (symbol? s) (list s) (caddr s)))

(define (needs-register? seq reg)
  (element-of-set? reg (registers-needed seq)))

(define (modifies-register? seq reg)
  (element-of-set? reg (registers-modified seq)))



(define (compile-linkage linkage)
  (cond ((eq? linkage 'return)
	 (make-instruction-sequence
	  '(continue)
	  empty-set
	  '((goto (fetch continue)))))
        ((eq? linkage 'next)		;implicit jump to next.
         (empty-instruction-sequence))
	(else
	 ;; No needs or clobbers because 
	 ;; code jumped to will be appended
	 ;; in line -- not enforced.
	 (make-instruction-sequence empty-set empty-set
	  `((goto ,linkage))))))

(define (make-label name)
  (generate-uninterned-symbol name))

