;;check to see how many of these are necessary

(define nil '())

(define the-empty-stream '())
(define stream-null? null?)
(define stream-first head)
(define stream-rest tail)


;;ordinary list filter

(define (filter pred list)
  (cond ((null? list) '())
        ((pred (car list))
         (cons (car list)
	       (filter pred (cdr list))))
        (else (filter pred (cdr list)))))



(define (stream-filter pred stream)
  (cond ((stream-null? stream) the-empty-stream)
        ((pred (stream-first stream))
         (cons-stream (stream-first stream)
                      (stream-filter pred (stream-rest stream))))
        (else (stream-filter pred (stream-rest stream)))))


(define (stream-map proc stream)
  (if (stream-null? stream)
      the-empty-stream
      (cons-stream (proc (stream-first stream))
                   (stream-map proc (stream-rest stream)))))


(define (stream-for-each p s)
  (if (stream-null? s)
      'done
      (begin (p (stream-first s))
	     (stream-for-each p
 (stream-rest s)))))


(define (stream-append s1 s2)
  (if (stream-null? s1)
      s2
      (cons-stream (stream-first s1)
		   (stream-append (stream-rest s1) s2))))


(define (list->stream l)
  (if (null? l)
      the-empty-stream
      (cons-stream (car l) (list->stream (cdr l)))))

(define (stream->list s)
  (if (stream-null? s)
      '()
      (cons (stream-first s)
	    (stream->list (stream-rest s)))))


(define (stream-ref stream n)
  (if (= n 0)
      (stream-first stream)
      (stream-ref (stream-rest stream) (- n 1))))


(define (stream-pairs s)
  (if (stream-null? s)
      the-empty-stream
      (stream-append
       (stream-map
	(lambda (sn) (list (stream-first s) sn))
	(stream-rest s))
       (stream-pairs (stream-rest s)))))

