;;;; Code for PS6.  This part of the code is not compiled.  It needs
;;;; to be cleaned up.  This depends on a bunch of compiled
;;;; procedures in PS6-DTRANS

;;; this code was modified for scheme by Joseph Boerjes for 6.001  
;;; original lisp code provided by daniel huttenlocher with copyrights
;;; as explained below. 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; -*- mode: lisp; syntax: common-lisp; package:(match scl) -*-           ;
;;;                                                                        ;
;;; copyright (c) 1988, 1989, 1990 daniel huttenlocher                     ;
;;;                                                                        ;
;;; this code may not be used for commercial purposes without the written  ;
;;; permission of the author.                                              ;
;;;                                                                        ;
;;; code for computing 3d alignment transform (from 3 points)              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; ALIGNMENT CODE

;;; Use function 3D-ALIGNMENT-TRANSFORM to compute a 3d similarity
;;; transform mapping points in model coordinate frame to image plane.
;;; Requires a triple of 3D model points, a triple of 2D image points,
;;; plus parameter (T or NIL) as to which of the family of two
;;; solutions to use.

;;; Use ALIGNMENT-TRANSFORM-PT to apply the above computed transform to
;;; a model point.

(define (alignment-transform-pt pt trans)
  (fix-v (vadd2 (alignment-transform-translation trans)
		(3d->2d-pt 
		 (transform-3d pt 
			       (alignment-transform-matrix trans))))))

(define (alignment-rotate-pt pt trans)
  (transform-3d pt (alignment-transform-matrix trans)))

(define (3d-alignment-transform model-triple image-triple flag)
  (let* ((ai (car image-triple))
	 (bi (cadr image-triple))
	 (ci (caddr image-triple))
	 (am (car model-triple))
	 (bm (cadr model-triple))
	 (cm (caddr model-triple))
	 (neg-c1c2 flag)
	 (bt (vdiff3 bm am))
	 (ct (vdiff3 cm am))
	 (rotation-1 (rotation-to-z=0-plane bt ct))
	 (translation-2 ai)
	 (l (2d-linear-transform
	     (3d->2d-pt (transform-3d bt rotation-1))
	     (3d->2d-pt (transform-3d ct rotation-1))
	     (vdiff2 bi translation-2)
	     (vdiff2 ci translation-2)))
	 (translation-1 (vscale3 -1 am))
	 (rotation-2 
	  (3d-scaled-rotation-from-2d-linear-transform l neg-c1c2)))
					;    (if (> (determinant-3d rotation-2) 0)
					;	(begin
					;	  ;THERE IS A SIGN ERROR SOMEWHERE, SHOULD BE MINUSP
					;	  (set-3d-matrix-r13! rotation-2 (- (3d-matrix-r13 rotation-2)))
					;	  (set-3d-matrix-r23! rotation-2 (- (3d-matrix-r23 rotation-2)))
					;	  (set-3d-matrix-r33! rotation-2 (- (3d-matrix-r33 rotation-2)))))
    (compose-alignment-transform rotation-1 translation-1 
				 rotation-2 translation-2)))


;;; hack for moving an object

(define pi 3.1415927)

(define (transform-model rotation-axis rotation-angle translation scale model-list)
  (let ((c (cos rotation-angle))
	(s (sin rotation-angle)))
    (define (transform-pt pt)
      (vscale3 scale
	       (vadd3 (vadd3 (vscale3 c pt)
			     (vadd3 (vscale3 (* (- 1 c) (vdot3 pt rotation-axis)) rotation-axis)
				    (vscale3 s (vcross3 rotation-axis pt))))
		      ;; this is rotated pt
		      ;; add in translation
		      translation)))
    (define (do-seg segment)
      (let ((new-seg (make-segment (transform-pt (seg-start segment))
				   (transform-pt (seg-end segment)))))
	;; project into image
	(make-segment (make-2d-pt (3d-pt-x (seg-start new-seg))
				  (3d-pt-y (seg-start new-seg)))
		      (make-2d-pt (3d-pt-x (seg-end new-seg))
				  (3d-pt-y (seg-end new-seg))))))
    (define (map-and-project-model model-lst)
      (cond ((null? model-lst)
	     '())
	    (else (cons (do-seg (car model-lst))
			(map-and-project-model (cdr model-lst))))))
    (map-and-project-model model-list)))



;;; below is test set that should be provided

(define test-model (list (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 0 1 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 0 1 1))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 0 0 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 0 0 0))

			 (make-segment (make-3d-point 5 0 0)
				       (make-3d-point 5 1 0))
			 (make-segment (make-3d-point 5 1 0)
				       (make-3d-point 5 1 1))
			 (make-segment (make-3d-point 5 1 1)
				       (make-3d-point 5 0 1))
			 (make-segment (make-3d-point 5 0 1)
				       (make-3d-point 5 0 0))

			 (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 5 0 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 5 1 0))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 5 1 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 5 0 1))))

(define test-cube (list (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 0 1 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 0 1 1))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 0 0 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 0 0 0))

			 (make-segment (make-3d-point 1 0 0)
				       (make-3d-point 1 1 0))
			 (make-segment (make-3d-point 1 1 0)
				       (make-3d-point 1 1 1))
			 (make-segment (make-3d-point 1 1 1)
				       (make-3d-point 1 0 1))
			 (make-segment (make-3d-point 1 0 1)
				       (make-3d-point 1 0 0))

			 (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 1 0 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 1 1 0))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 1 1 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 1 0 1))))



(define test-tetra (list (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 2 0 0))
			 (make-segment (make-3d-point 2 0 0)
				       (make-3d-point 2 2 0))
			 (make-segment (make-3d-point 2 2 0)
				       (make-3d-point 0 2 0))
			 (make-segment (make-3d-point 0 2 0)
				       (make-3d-point 0 0 0))

			 (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 1 1 6))
			 (make-segment (make-3d-point 2 0 0)
				       (make-3d-point 1 1 6))
			 (make-segment (make-3d-point 0 2 0)
				       (make-3d-point 1 1 6))
			 (make-segment (make-3d-point 2 2 0)
				       (make-3d-point 1 1 6))))


(define test-tri (list (make-segment (make-3d-point 0 0 0)
				     (make-3d-point 2 0 0))
		       (make-segment (make-3d-point 2 0 0)
				     (make-3d-point 1 2 0))
		       (make-segment (make-3d-point 1 2 0)
				     (make-3d-point 0 0 0))

		       (make-segment (make-3d-point 0 0 5)
				     (make-3d-point 2 0 5))
		       (make-segment (make-3d-point 2 0 5)
				     (make-3d-point 1 2 5))
		       (make-segment (make-3d-point 1 2 5)
				     (make-3d-point 0 0 5))

		       (make-segment (make-3d-point 0 0 0)
				     (make-3d-point 0 0 5))
		       (make-segment (make-3d-point 2 0 0)
				     (make-3d-point 2 0 5))
		       (make-segment (make-3d-point 1 2 0)
				     (make-3d-point 1 2 5))))

(define test-bend (list (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 0 1 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 0 1 1))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 0 0 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 0 0 0))

			 (make-segment (make-3d-point 5 0 0)
				       (make-3d-point 5 1 0))
			 (make-segment (make-3d-point 4 1 1)
				       (make-3d-point 4 0 1))

			 (make-segment (make-3d-point 0 0 0)
				       (make-3d-point 5 0 0))
			 (make-segment (make-3d-point 0 1 0)
				       (make-3d-point 5 1 0))
			 (make-segment (make-3d-point 0 1 1)
				       (make-3d-point 4 1 1))
			 (make-segment (make-3d-point 0 0 1)
				       (make-3d-point 4 0 1))

			 (make-segment (make-3d-point 5 0 0)
				       (make-3d-point 5 0 5))
			 (make-segment (make-3d-point 5 1 0)
				       (make-3d-point 5 1 5))
			 (make-segment (make-3d-point 4 1 1)
				       (make-3d-point 4 1 5))
			 (make-segment (make-3d-point 4 0 1)
				       (make-3d-point 4 0 5))

			 (make-segment (make-3d-point 5 0 5)
				       (make-3d-point 5 1 5))
			 (make-segment (make-3d-point 5 1 5)
				       (make-3d-point 4 1 5))
			 (make-segment (make-3d-point 4 1 5)
				       (make-3d-point 4 0 5))
			 (make-segment (make-3d-point 4 0 5)
				       (make-3d-point 5 0 5))))



(define test-image (append (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 8 8 0)
					    10
					    test-cube)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 3 3 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 8 3 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 3 8 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 1 1 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 1 8 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 1 15 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 8 1 0)
					    5
					    test-model)))

(define test-image-1 (append (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 8 8 0)
					    10
					    test-cube)		      
			   (transform-model (vunit3 (make-3d-point 1 0 1))
					    (/ pi 4)
					    (make-3d-point 3 3 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 0))
					    (/ pi 4)
					    (make-3d-point 8 3 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 0 1 1))
					    (/ pi 4)
					    (make-3d-point 3 8 0)
					    10
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 1 1 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 0 1))
					    (/ pi 4)
					    (make-3d-point 1 8 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 0))
					    (/ pi 4)
					    (make-3d-point 1 15 0)
					    5
					    test-model)
			   (transform-model (vunit3 (make-3d-point 1 1 1))
					    (/ pi 4)
					    (make-3d-point 8 1 0)
					    5
					    test-model)))

(define trial-cube (transform-model (vunit3 (make-3d-point 1 1 1))
				     (/ pi 4)
				     (make-3d-point 5 8 0)
				     10
				     test-cube))


(define test-examples (list test-model test-bend test-tetra test-tri))

(define (select-random lst)
  (list-ref lst (random (length lst))))


(define (make-test-image num)
  (define (aux num)
    (cond ((= num 0) nil)
	  (else
	   (append 
	     (transform-model (vunit3 (make-3d-point (random 10) (random 10) (random 10)))
			    (* (/ pi 180) (random 180))
			    (make-3d-point (random 12) (random 12) (random 12))
			    (+ 2 (random 10))
			    (select-random test-examples))
	     (aux (- num 1))))))
  (aux num))

