;;; -*- Scheme -*-

;;; Load file and instructions for building this program.

;;; Things you may need to edit:
;;;
;;; The definitions of SYNTAX-ERROR and IMPL-ERROR in "synout.scm",
;;; and the definition of EVALUATION-ERROR in "eval.scm".
;;;
;;; "trenv.scm" contains a list of all of the global variables defined
;;; by R4RS.  Comment out any variables that your system doesn't
;;; define.

;;; Comment out this line if your system supports records:
(load "record.scm")

;;; This file is the macro expander proper.
(load "synclo.scm")

;;; This file defines the output language.
(load "synout.scm")

;;; These files define an evaluator for the output language.
(load "eval.scm")
(load "trenv.scm")

;;; These files define the R4RS syntactic environment.
(load "r4rsyn.scm")
(load "synrul.scm")

;;; This file contains a simple pattern-matcher that is used by the
;;; special-form expanders to check their inputs in a concise way.
(load "synchk.scm")

;;; OK, time to build the databases.
(initialize-transformer-environments!)
(initialize-scheme-syntactic-environment!)

;;; RUN is for you to use.  It takes an R4RS expression, macro-expands
;;; it, and returns the result of the macro expansion.
(define (run expression)
  (set! *counter* 0)
  (compile/top-level (list expression) scheme-syntactic-environment))