; -*- Scheme -*-
;
; $Id$

(require 'btree)

(define bawk::pred?
  (lambda (a b)
    (cond ((string? a)
	   (cond ((string? b) (string<? a b))
		 ((number? b) (string<? a (number->string b)))
		 (else (error 'bawk::pred? "invalid type"))))
	  ((number? a)
	   (cond ((number? b) (< a b))
		 ((string? b) (string<? (number->string a) b))
		 (else (error 'bawk::pred? "invalid type"))))
	  (else (error 'bawk::pred? "invalid type")))))


;+doc
; procedure: bawk:table
; arguments: none
; signature: () -> bawk:table
;
; Creates a new table.
;-doc

(define bawk:table make-btree)


;+doc
; procedure: bawk:table:delete
; arguments: element table
; signature: (string|number) x bawk:table -> unspecified
;
; Removes ELEMENT from TABLE.
;-doc

(define bawk:table:delete
  (let ((ignore (lambda (_) #t)))
    (lambda (k t)
      (btree-delete! t btree::pred? car k ignore ignore))))


;+doc
; procedure: bawk:table=
; arguments: key value table
; signature: (string|number) x (string|number) x bawk:table -> unspecified
;-doc

(define bawk:table=
  (let ((fail (lambda (_) #f)))
    (lambda (k v t)
      (btree-insert! t bawk::pred? car k (lambda (k) (cons k v)) car fail))))


;+doc
; procedure: bawk:table[]
; arguments: key table
; signature: (string|number) x bawk:table -> b|#f
;
; Returns the value in TABLE with the given KEY or #f if there is no
; element with the KEY.
;-doc

(define bawk:table[]
  (let ((fail (lambda (_) #f)))
    (lambda (k t)
      (btree-lookup t bawk::pred? car k cdr fail))))

; eof
