;;; globals.s declaration of types for Scheme constants

;;; slightly hacked for Chez Scheme, etc. Wed Nov  9 11:23:41 1988


(define pair cons)
(define lson car)
(define rson cdr)
(define true #t)
(define false #f)

(define any '*any*)
(define print (lambda (x) (printf "~s" x)))
(define newline (lambda () (printf "~%")))
(define unchecked (lambda (x) x))

(extend-syntax (fix)
  ((fix name exp) (rec name exp)))

(extend-syntax (and)
  ((and) true)
  ((and x y ...)
   (if x (and y ...) false)))

(extend-syntax (or)
  ((or) false)
  ((or x y ...)
   (if x true (or y ...))))

(extend-syntax (letrec)
  [(letrec ((x v) ...) e1 e2 ...)
   (let ((x any) ...)
     (set! x v) ...
     e1 e2 ...)])

(define-type-abbrev bool (bool))
(define-type-abbrev int (int))
(define-type-abbrev symbol (symbol))
(define-type-abbrev literal (symbol))	; for compatibility
(define-type-abbrev string (string))
(define-type-abbrev triv (triv))	; (triv) defined below
(define-type-abbrev char (char))	; no use yet, should revise
					; this file to use it.

(declare-unchecked * () (-> (seq int int) int))
(declare-unchecked + () (-> (seq int int) int))
(declare-unchecked - () (-> (seq int int) int))
(declare-unchecked / () (-> (seq int int) int))
(declare-unchecked 1+ () (-> (seq int) int))
(declare-unchecked 1- () (-> (seq int) int))
(declare-unchecked < () (-> (seq int int) bool))
(declare-unchecked <= () (-> (seq int int) bool))
(declare-unchecked = () (-> (seq int int) bool))
(declare-unchecked > () (-> (seq int int) bool))
(declare-unchecked >= () (-> (seq int int) bool))
(declare-unchecked abs () (-> (seq int) int))
(declare-unchecked any (x) x)		; initialization eg '*
(declare-unchecked append (x) (-> (seq (list x) (list x)) (list x)))
(declare-unchecked append! (x) (-> (seq (list x) (list x)) (list x)))
(declare-unchecked atom? (x) (-> (seq x) bool))
(declare-unchecked cadddr (y) (-> (seq (list y)) y))
(declare-unchecked caddr (y) (-> (seq (list y)) y))
(declare-unchecked cadr (y) (-> (seq (list y)) y))
(declare-unchecked car (y) (-> (seq (list y)) y))
(declare-unchecked cdddr (y) (-> (seq (list y)) (list y)))
(declare-unchecked cddr (y) (-> (seq (list y)) (list y)))
(declare-unchecked cdr (y) (-> (seq (list y)) (list y)))
(declare-unchecked cons (x) (-> (seq x (list x)) (list x)))
(declare-unchecked display (x) (-> (seq x) bool))
(declare-unchecked eq? (x) (-> (seq x x) bool))
(declare-unchecked equal? (x) (-> (seq x x) bool))
(declare-unchecked eqv? (x) (-> (seq x x) bool))
(declare-unchecked error (x) (-> (seq string . x) y))
(declare-unchecked exit (y) (-> (seq) y))
(declare-unchecked false () bool)
(declare-unchecked file-exists? () (-> (seq string) bool))
(declare-unchecked gensym (x) (-> (seq x) literal))
(declare-unchecked if (z) (-> (seq bool z z) z))
(declare-unchecked last-pair (x) (-> (seq (list x)) (list x)))
(declare-unchecked length (x) (-> (seq (list x)) int))
(declare-unchecked list-ref (x) (-> (seq (list x) int) x))
(declare-unchecked list-tail (x) (-> (seq (list x) int) (list x)))
(declare-unchecked lson (x y) (-> (seq (pair x y)) x))
(declare-unchecked map (x y z) (-> (seq (-> (seq x) y) (list x)) (list z)))
(declare-unchecked max () (-> (seq int int) int))
(declare-unchecked member (x) (-> (seq x (list x)) bool))
(declare-unchecked memq () (-> (seq literal (list literal)) bool))
(declare-unchecked memv (x) (-> (seq x (list x)) bool))
(declare-unchecked min () (-> (seq int int) int))
(declare-unchecked minus () (-> (seq int) int))
(declare-unchecked modulo () (-> (seq int int) int))
(declare-unchecked negative? () (-> (seq int) bool))
(declare-unchecked newline (x) (-> (seq) bool))
(declare-unchecked nil (z) (list z))
(declare-unchecked not () (-> (seq bool) bool))
(declare-unchecked null? (z) (-> (seq (list z)) bool))
(declare-unchecked number? (x) (-> (seq x) bool))
(declare-unchecked pair (x y) (-> (seq x y) (pair x y)))
(declare-unchecked pair? (x) (-> (seq x) bool))
(declare-unchecked positive? () (-> (seq int) bool))
(declare-unchecked pretty-print (x) (-> (seq x) bool))
(declare-unchecked print (x) (-> (seq x) bool))
(declare-unchecked printf (x) (-> (seq string . x) bool))
(declare-unchecked print-length (x) (-> (seq x) int))
(declare-unchecked random () (-> (seq int) int))
(declare-unchecked read-char () (-> (seq) literal))
(declare-unchecked remainder () (-> (seq int int) int))
(declare-unchecked reset (y) (-> (seq) y))
(declare-unchecked reverse (x) (-> (seq (list x)) (list x)))
(declare-unchecked reverse! (x) (-> (seq (list x)) (list x)))
(declare-unchecked rson (x y) (-> (seq (pair x y)) y))
(declare-unchecked set! (x) (-> (seq x x) x))
(declare-unchecked set-car! (x y) (-> (seq (pair x y) x) (pair x y)))
(declare-unchecked set-cdr! (x y) (-> (seq (pair x y) y) (pair x y)))
(declare-unchecked string<? () (-> (seq string string) bool))
(declare-unchecked string? (x) (-> (seq x) bool))
(declare-unchecked subst (x) (-> (seq x x (list x)) (list x)))
(declare-unchecked substring () (-> (seq string int int) string))
(declare-unchecked symbol? (x) (-> (seq x) bool))
(declare-unchecked syntactic-extension? () (-> (seq literal) bool))
(declare-unchecked true () bool)
(declare-unchecked zero? () (-> (seq int) bool))


;;; definitions not in Chez Scheme
;(declare-unchecked #!if (z) (-> (seq bool z z) z))
;(declare-unchecked <0 () (-> (seq int) bool))
;(declare-unchecked <=? () (-> (seq int int) bool))
;(declare-unchecked <? () (-> (seq int int) bool))
;(declare-unchecked =0 () (-> (seq int) bool))
;(declare-unchecked =? () (-> (seq int int) bool))
;(declare-unchecked >0 () (-> (seq int) bool))
;(declare-unchecked >=? () (-> (seq int int) bool))
;(declare-unchecked >? () (-> (seq int int) bool))
;(declare-unchecked alpha< () (-> (seq literal literal) bool))
;(declare-unchecked ascii->symbol () (-> (seq int) literal))
;(declare-unchecked concat () (-> (seq string string) string))
;(declare-unchecked copy (x) (-> (seq x) x))
;(declare-unchecked current-column () (-> (seq) int))
;(declare-unchecked delete! (x) (-> (seq x (list x)) (list x)))
;(declare-unchecked delq! (x) (-> (seq x (list x)) (list x)))
;(declare-unchecked display& (x) (-> (seq x) bool))
;(declare-unchecked error (x y) (-> (seq . x) y))
;(declare-unchecked explode () (-> (seq literal) (list literal)))
;(declare-unchecked fix? (x) (-> (seq x) bool))
;(declare-unchecked float? (x) (-> (seq x) bool))
;(declare-unchecked flush-input () (-> (seq) bool))
;(declare-unchecked flush-output () (-> (seq) bool))
;(declare-unchecked implode () (-> (seq (list literal)) literal))
;(declare-unchecked line-length () (-> (seq) int))
;(declare-unchecked macro? (x) (-> (seq x) bool))
;(declare-unchecked mapcar (x y) (-> (seq (-> (seq x) y) (list x)) (list y)))
;(declare-unchecked port? (x) (-> (seq x) bool))
;(declare-unchecked print& (x) (-> (seq x) bool))
;(declare-unchecked read-atom () (-> (seq) literal))
;(declare-unchecked set-line-length! () (-> (seq int) int))
;(declare-unchecked symbol->ascii () (-> (seq literal) int))
;(declare-unchecked thaw (x) (-> (seq (-> (seq) x)) x))
;(declare-unchecked writeln (x) (-> (seq . x) bool))
;; maybe this works for Chez;

;;; ****************************************************************

;;; standard type constructors

(define-record-type (triv)
  (make-triv ()))

(define-checked triv triv (make-triv))

;;; which of these shall we use??  I vote for the first (replacing
;;; casefn by union-case.

(define-record-type (union x y)
   (inL (x))
   (inR (y)))

'(define-type-constructor (union x y)
  (pair literal (pair x y))
  (inL
    (generic (x y)
      (-> (seq x) (union x y)))
    (lambda (v)
      (enc (pair 'L (pair v any)))))
  (inR
    (generic (x y)
      (-> (seq y) (union x y)))
    (lambda (v)
      (enc (pair 'R (pair any v)))))
  (casefn
    (generic (x y z)
      (-> (seq (union x y)
	       (-> (seq x) z)
	       (-> (seq y) z))
	  z))
    (lambda (l f g)
      ((lambda (q)
	 (if (eq? q 'L)
	   (f (lson (rson (dec l))))
	   (if (eq? q 'R)
	     (g (rson (rson (dec l))))
	     (reset))))
       (lson (dec l))))))


;;; ****************************************************************

; This declaration of apply is useless and should be ignored.  It is present
; for historical reasons only.

'(declare-unchecked 
   apply (x y) 
   (->
      (seq
	 (-> (seq . x) y)
	 (seq . x))
      y))

;;; ****************************************************************

(define-type-constructor (alist x)
  (list (pair literal x))
  (alist$ext
    (generic (x)
      (-> (seq (alist x) literal x)
	  (alist x)))
    (lambda (l id val)
      (enc (cons (pair id val) (dec l)))))
  (alist$bvars
    (generic (x) 
      (-> (seq (alist x)) (list literal)))
    (lambda (l) (map lson (dec l))))
  (alist$init
    (generic (x)
      (alist x))
    (enc nil)))


