;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;; Macros used by the zebu system.
;;;
;;; Some might find these globally defined macros to be pollution, but
;;; they are only used when the zebu system is compiled.

;;; def-macro is a macro definer which is defined variously
;;; for the differing scheme implementations.  It is very roughly of the 
;;; style of the common lisp defmacro.  

;;; Comment out some forms.

(def-macro (comment-out . forms)
  '())


;;; Push and pop on symbols which name lists.

(def-macro (push elt list-sym)
  `(set! ,list-sym (cons ,elt ,list-sym)))

(def-macro (pop list-sym)
  `(let ((top (car ,list-sym)))
     (set! ,list-sym (cdr ,list-sym))
     top))

;;; Pops the first n items from list-sym and returns it  in reverse order in
;;;  a list.

(def-macro (popn n list-sym)
  `(do ((i 0 (+ 1 i))
	(res '()))
       ((= i ,n) res)
     (push (pop ,list-sym) res)))

;;; Like the postfix ++ operator of `c'

(def-macro (post-inc x)
  `(let ((old ,x))
     (set! ,x (1+ ,x))
     old))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test stuff:
;;;
;;; I guess this macro won't have taken effect yet in c-scheme in this file...
;;; (comment-out
;;;  (define fred '())
;;;  (push 'a fred)
;;;  fred
;;;  (push 'b fred)
;;;  fred
;;;  (pop fred)
;;;  fred)
;;; 
;;; (comment-out
;;;  (define fred 2)
;;;  (post-inc fred)
;;;  fred
;;;  (define fred '(a b c d e))
;;;  (popn 3 fred)
;;;  fred
;;; 
;;;  )


;;; PC scheme requires a control-Z at the end of each source file: 
