;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;; Grammar symbols are represented by g-symbol structs.
;;;
;;;
;;; print-name is a string.  
;;;
;;; index is a unique integer associated with the symbol.
;;;
;;; own-productions is a list of
;;; the productions that the symbol appears on the left side of.
;;; rhs-productions is a list of the productions the symbol appears
;;; on the right side of.
;;;
;;; first-set is the set of terminal grammar symbols which can
;;; legally start a string derived from the symbol.
;;;
;;; first-set-dependers is used in the computation of the first-set.
;;;
;;; derives-empty-string is a quick way of telling if the empty
;;; string is in the first-set of the symbol.
;;;
;;; follow-set is the set of terminal symbols which may appear after
;;; the symbol in strings of the language.
;;;
;;; follow-dependers is the set of grammar symbols whose follow sets
;;; must contain this guys follow set.
;;; sets will be represented by o-sets.
;;;
;;; A hack -- a g-symbol is non-terminal is own-productions is '().

(define-struct g-symbol
  print-name
  index
  own-productions
  rhs-productions
  first-set
  first-set-dependers
  derives-empty-string
  follow-set
  follow-dependers)


(define (g-symbol-non-terminal? sym)
  (not (null? (g-symbol-own-productions sym))))

(define (print-g-symbol sym) (display (g-symbol-print-name sym)))

(define (new-g-symbol print-name index)
  (make-g-symbol
   'print-name print-name
   'index index
   'own-productions '()
   'rhs-productions '()
   'first-set (make-oset 'order-fn g-symbol-order-function)
   'first-set-dependers (make-oset 'order-fn g-symbol-order-function)
   'follow-set (make-oset 'order-fn g-symbol-order-function)
   'follow-dependers (make-oset 'order-fn g-symbol-order-function)))

(define (g-symbol-order-function sa sb)
  (cond ((< (g-symbol-index sa) (g-symbol-index sb)) 'correct-order)
	((> (g-symbol-index sa) (g-symbol-index sb)) 'wrong-order)
	(else 'equal)))

(define (g-symbol-add-production g-symbol production)
  (set-slot! (g-symbol-own-productions g-symbol)
	(cons production (g-symbol-own-productions g-symbol))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test
(comment-out
 (load "g-symbol")
 (define g1 (new-g-symbol "foo" 3))
 (define g2 (new-g-symbol "goo" 5))
 (g-symbol-order-function g1 g2)
 (g-symbol-non-terminal? g1)
 (print-g-symbol g1)
)
 

;;; PC scheme requires a control-Z at the end of each source file: 
