;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;; Some c-scheme specific compatibility macros.  Note that this
;;; file contains only macros, so it only needs to be around 
;;; when the zebu system is compiled.

;;; The following defines a macro which is used to define
;;; macros compatibly in c-scheme and pc-scheme.  Some might 
;;; consider it anti-social to modify the global syntax table.
;;; I did it this way to help keep the code portable.  Note that
;;; the macros here only need to be present when the zebu system
;;; is compiled.

(define-macro (def-macro invocation expansion-template)
  `(syntax-table-define system-global-syntax-table
       ',(car invocation)
     (macro ,(cdr invocation) ,expansion-template)))



;;; Some hacks to make a defstruct thingy which is compatible
;;; with the define-structure facilities of both c-schmem
;;; and ti pc-scheme.
;;; The strategey is to use the form DEFINE-STRUCT for 
;;; definitions (and get keyword constructors)
;;; and to use the macro SET-SLOT! in the style of setf (of common lisp)
;;; for mutations.  All this since the pc-scheme facility uses
;;; setf style, and can't do positional constructors. This is
;;; the least common denominator approach.

(def-macro (define-struct name . slots)
  `(define-structure (,name (keyword-constructor t)) ,@slots))

(def-macro (set-slot! accessor-form value)
  `(,(intern
      (string-append "set-" 
		     (string-downcase (symbol->string 
				       (car accessor-form))) "!"))
    ,(cadr accessor-form)
    ,value))


;;; Complain and cause an error if the asserted truth isn't.

(def-macro (assert truth complaint)
  `(if (not ,truth)
      (begin
	(display "assertion failed: ")
	(display ,complaint)
	(error ,complaint))))



;;; A single argument eval macro.

(def-macro (one-arg-eval form)
  `(eval ,form user-initial-environment))


