;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

(define *jacal-version* "1a0")

(load (in-vicinity (program-vicinity) "types"))
			;Variables and type conversions.
(define (math_exit b) (cleanup-handlers!) (error "error in math system"))
	;error handling when not running (math) [read-eval-print loop]
;(define *diagnostic-output* (current-output-port))
(define math_debug #f)	;break on soft errors.
(define math_trace #f)	;trace canonical function application.
(load (in-vicinity (program-vicinity) "grammar"))
			;grammar, I/O, test, and error routines.
(define *input-grammar* (get-grammar 'scheme))
			;grammar to use if none is loaded.
(define *output-grammar* (get-grammar 'scheme))
			;grammar to use if none is loaded.
(define *echo-grammar* (get-grammar 'null))

(define *symdefs* (make-hash-table 37))	;":" environment.
(load (in-vicinity (program-vicinity) "sect"))
			;variable naming
(load (in-vicinity (program-vicinity) "sexp"))
			;read-eval-print loop.  Conversion from
			;sexpression to internal form and back.
(load (in-vicinity (program-vicinity) "poly"))
			;Routines which operate on internal data type POLY.
(load (in-vicinity (program-vicinity) "vect"))
			;Routines which operate on lists of POLY (mtrx).
(load (in-vicinity (program-vicinity) "norm"))
			;Differentials, finite differentials,
			;factoring, and logical operations.
(load (in-vicinity (program-vicinity) "builtin"))
			;Routines defined for sexpressions.
(define link-radicands #t)	;Relate radicals in the traditional manner.
(load (in-vicinity (program-vicinity) "ext"))
			;Field extension creation and simplification.
(load (in-vicinity (program-vicinity) "parse"))
			;General parser
(load (in-vicinity (program-vicinity) "unparse"))
			;infix printer.
(load (in-vicinity (program-vicinity) "stdgrm"))
			;Standard grammar definitions.
;;; These routines test the core mathematical routines;
;;; Beware if they produce warnings or errors.
(poly_test)		;Test for routines in "poly"
(elim_test)		;Test for routines in "bunch"
;(factor_test)
;(matrix_test)
;(load (in-vicinity (user-vicinity) "math.ini"))
			;User initialization file
(display "
JACAL version ")
(display *jacal-version*)
(display ", Copyright 1989, 1990, 1991, 1992 Aubrey Jaffer
JACAL comes with ABSOLUTELY NO WARRANTY; for details type `(terms)'.
This is free software, and you are welcome to redistribute it
under certain conditions; type `(terms)' for details.
")
(display ";;; Type (math) to begin.")
(newline)
(force-output)
