;;;; -*- Scheme -*-
;;;; $Header: upper-to-hyphen.scm,v 1.1 91/06/02 16:30:09 bevan Exp $

;;;+file-summary
;;; Converts identifiers written in mixedCase into ones that use-a-hyphen.
;;;
;;; Stephen J. Bevan <bevan@cs.man.ac.uk>
;;;-

;;;+fs
;;; Reads characters from the `inputPort' and converts any identifiers that 
;;; use a mixed case convention to the hyphenated-word convention.  All output
;;; is directed to the `outputPort'
;;;-
(define input-port:upperCase->hyphens
  (lambda (inputPort outputPort)
    (let loop ((currentChar (read-char inputPort))
	       (translateChar #f))
      (if (not (eof-object? currentChar))
	  (loop (read-char inputPort)
		(if (char-upper-case? currentChar)
		    (begin
		      (if translateChar
			  (begin
			    (display "-" outputPort)
			    (display (char-downcase currentChar) outputPort))
			  (display currentChar outputPort))
		      #f)
		    (begin
		      (display currentChar outputPort)
		      (char-lower-case? currentChar))))))))

;;;+fs
;;; Converts the `inputFile' so that the mixedCase identifiers used in it
;;; are converted to use hyphens i.e. mixed-case.  The converted `inputFile'
;;; is written to the `outputFile'
;;;-
(define input-file:upperCase->hyphens
  (lambda (inputFile outputFile)
    (let ((inputPort (open-input-file inputFile))
	  (outputPort (open-output-file outputFile)))
      (input-port:upperCase->hyphens inputPort outputPort)
      (close-input-port inputPort)
      (close-output-port outputPort))))
