;;;; -*- Scheme -*-
;;;; $Header: /home/panda/pg/bevan/progs/scheme/misc/RCS/read-line.scm,v 1.2 91/05/26 12:28:54 bevan Exp $

;;;+file-summary
;;; A portable version of `read-line'.
;;; This reads a whole line from a port and returns it as a string
;;;- +extensions
;;; provide
;;;   a la old CommonLisp.  Just remove the line if you Scheme doesn't use
;;;   provide/require
;;;-

;;;+vs
;;; The number of characters in each chunk that is read in.  Change
;;; as appropriate for your system.  If you scheme has constants, then
;;; its a good idea to define this as one.
;;;-
(define read-line-chunk-size 80)

;;;+fs
;;; Reads a line from the given input port or from the current input port
;;; if none is specified.
;;; A `line' is defined as all the characters up to a newline character or
;;; the end of the file.
;;; An eof object is returned if the end of file is encountered when attempting
;;; to read the first character.  If the end of file is encountered after
;;; the first character is read, all the characters that have been read
;;; so far are returned.
;;;-
(define (read-line . optional-port)
  (define (read-chunk in-port)
    (let ((buffer (make-string read-line-chunk-size)))
      (let loop ((pos 0))
	(if (= pos read-line-chunk-size)
	    (let ((next-chunk (read-chunk in-port)))
	      (if (eof-object? next-chunk)
		  buffer
		  (string-append buffer next-chunk)))
	    (let ((chr (read-char in-port)))
	      (cond ((eof-object? chr)
		     (if (zero? pos) chr (substring buffer 0 pos)))
		    ((char=? chr #\Newline) (substring buffer 0 pos))
		    (else
		     (string-set! buffer pos chr)
		     (loop (+ 1 pos)))))))))
  (let ((in-port (if (null? optional-port)
		     (current-input-port)
		     (car optional-port))))
    (read-chunk in-port)))

;;;+system scm elk
(provide 'read-line)
;;;-
