;;;; -*- Scheme -*-
;;;; $Header: /home/panda/pg/bevan/progs/scheme/misc/RCS/quicksort.scm,v 1.2 91/05/18 19:10:55 bevan Exp $

;;;+file-summary
;;; An implementation of Quicksort for lists.
;;; Based on the quicksort that comes with New Jersey SML.
;;;-

;;;+fs
;;; Sorts a list using the `ordering-function' to define in what order
;;; the items in the list should be sorted.  The `ordering-function' should
;;; expect take two arguments and return #t if the first is ordered with
;;; respect to the second.
;;; Returns a function to be applied to the list of items.
;;;- +fe
;;; > (define lexical-string-sort (quick-sort string<=?))
;;; > (lexical-string-sort '("foo" "bar" "biff"))
;;; ("bar" "biff" "foo")
;;;-
(define (quick-sort ordering-function)
  (letrec
      ((sort
	(lambda (list-to-sort)
	  (if (or (null? list-to-sort) (null? (cdr list-to-sort)))
	      list-to-sort
	      (let ((pivot (car list-to-sort))
		    (rest (cdr list-to-sort)))
		(let split ((left '()) (right '()) (rest rest))
		  (if (null? rest)
		      (append (sort left) (cons pivot (sort right)))
		      (if (ordering-function (car rest) pivot)
			  (split (cons (car rest) left) right (cdr rest))
			  (split left (cons (car rest) right) (cdr rest))))))))))
  sort))
