;;;; -*- Scheme -*-
;;;; $Header: /home/panda/pg/bevan/progs/scheme/misc/RCS/gensym.scm,v 1.2 91/05/26 11:20:21 bevan Exp $
;;;+file-summary
;;; An implementation of CommonLisp/Chez Scheme function gensym
;;; This generates a new (hopefully) unique name.
;;;-
;;;+extensions
;;; provide
;;;   a la old CommonLisp.  Just remove the line if you Scheme doesn't use
;;;   provide/require
;;;-

;;;+fs
;;; Generate a new symbol that has hopefully not already been used.
;;; Optionally takes one string argument that is the prefix to use
;;; for the generated symbol
;;;- +fe
;;; > (gensym)
;;; G1
;;; > (gensym)
;;; G2
;;; > (gensym "f")
;;; f1
;;; > (gensym)
;;; G3
;;; > (gensym "f")
;;; f2
;;;-
(define gensym
  (let ((i 0))
    (lambda arg
      (set! i (+ 1 i))
      (string->symbol (string-append
		       (if (null? arg)
			   "G"
			   (car arg))
		       (number->string i))))))

(provide 'gensym)
