;;; Test of Sybase calls.
;;;
;;; Karl O. Pinc
;;;
;;; March 21, 1991


(define example ; Your basic sybase stub.
  (let* ((display-column
          (lambda (x)
            (display x)
            (display " ")))
         (run
          (lambda (dbproc)
            (let ((print-rows
                   (lambda (ok)
                     (if ok
                         (let ((c-types (column-types dbproc)))
                           (for-each-sql-row 
                            (lambda (rowinfo)
                              (if rowinfo
                                  (begin
                                   (map display-column
                                        (sql-columns->list dbproc
                                                           rowinfo
                                                           c-types))
                                   (newline))
                                  (error 'run "Error retrieving rows")))
                            dbproc))
                         (error 'run "Cannot select from sysobjects")))))
              
              (display "running") 
              (newline)
              (if dbproc
                  (begin
                   (for-each-sql-statement (lambda (ok)
                                             (if (not ok)
                                                 (error 'run "Cannot use citi.")))
                                           dbproc
                                           "use citi")
                   (for-each-sql-statement print-rows
                                           dbproc 
                                           "select id, name from sysobjects where type = 'U' order by name")
                   'done)
                  (error 'run "Cannot open a connection")))))
         
         (login
          (lambda (loginrec)
            (display "connecting")
            (newline)
            (if loginrec
                (call-with-dbproc run loginrec "SYBASE")
                (error 'login "Cannot get a loginrec."))))
         
         (use-sybase
          (lambda (ok)
            (fluid-let ((error 
                         ; Set it up so that invoking error resets sybase as well as scheme.
                         (let ((old-error error))
                           (lambda args 
                             (dbexit) 
                             (apply old-error args)))))
                       
                       (display "logging in")
                       (newline)
                       (if ok
                           (call-with-loginrec login "sa" "sa-password" "karl" "test app")
                           (error 'use-sybase "Cannot initialize sybase"))))))
    (lambda ()
      (display "starting")
      (newline)
      (call-with-sybase-ready use-sybase))))

(define test
  ; (test username password client-machine application-name server batches)
  ;
  ; Connect to a server, login, run batch(es), and display each batch followed
  ; by it's results.  Any errors cause the entire program to abort.
  ;
  ; All arguments are strings, except for batches which is a list of strings.
  ; Each string in batches is submitted as a separate batch.
  (lambda (username password client-machine application-name server batches)
    (let* ((display-column
            (lambda (x)
              (display x)
              (display " ")))
           (run
            (lambda (dbproc)
              (let ((make-print-rows
                     (lambda (query)
                       (lambda (ok)
                         (if ok
                             (let ((c-types (column-types dbproc)))
                               (for-each-sql-row 
                                (lambda (rowinfo)
                                  (if rowinfo
                                      (begin
                                       (map display-column
                                            (sql-columns->list dbproc
                                                               rowinfo
                                                               c-types))
                                       (newline))
                                      (error 'run 
                                             "Error retrieving rows for batch ~s." 
                                             query)))
                                dbproc))
                             (error 'run "Cannot run query" query))))))
                
                (if dbproc
                    (begin
                     (for-each
                      (lambda (batch)
                        (display batch)
                        (newline)
                        (for-each-sql-statement (make-print-rows batch)
                                                dbproc 
                                                batch))
                      batches)
                     'done)
                    (error 'run "Cannot open a connection to server ~a." server)))))
           
           (login
            (lambda (loginrec)
              (if loginrec
                  (call-with-dbproc run loginrec server)
                  (error 'login "Cannot get a loginrec."))))
           
           (use-sybase
            (lambda (ok)
              (fluid-let ((error 
                           ; Set it up so that invoking error resets
                           ; sybase as well as scheme.
                           (let ((old-error error))
                             (lambda args 
                               (dbexit) 
                               (apply old-error args)))))
                         
                         (if ok
                             (call-with-loginrec login 
                                                 username 
                                                 password 
                                                 client-machine 
                                                 application-name)
                             (error 'use-sybase "Cannot initialize sybase"))))))
      (call-with-sybase-ready use-sybase))))

(define run-test
  (lambda batches
    (test "sa" "admin" "The vax" "test application" "SYBASE" batches)))