;;
;; Sample redcode.
;;
(module redcode)
(include "cw.sch")

;;
;; the Classics
;;
(define dwarf-text
  '((label dest) (dat (% 0))
    (label loop) (add (% 4) (+ dest))
	(/* I'm going to mov %8 because I want to see if the move)
	(/* is working right AND because %8 is as good as any other)
	(/* number because immediate operands are not executable)
	(/* when moved.)
	             (mov (% 8) (^ dest))
	             (jmp (+ loop))))

(define (make-dwarf)
  (make-program 'dwarf 1 dwarf-text (rca dwarf-text)))

(define imp-text
  '((mov (+ 0) (+ 1))))

(define (make-imp)
  (make-program 'imp 0 imp-text (rca imp-text)))

(define gemini-text
  '((label src) (dat (% 0))
	(label dst) (dat (% 99))
	(label loop)(mov (^ src) (^ dst))
	            (cmp (+ src) (% 9))
                (jmp (+ done))
	            (add (% 1) (+ src))
	            (add (% 1) (+ dst))
	            (jmp (+ loop))
	(label done)(move (% 99) (+ 93))
	            (jmp (+ 93))))

(define (make-gemini)
  (make-program 'gemini 2 gemini-text (rca gemini-text)))

(define stomper-text
  '((label src) (dat (% 0))
	(label dst) (dat (% 191))
	(label loop)(mov (^ src) (^ dst))
	            (cmp (+ src) (% 13))
                (jmp (+ done))
	            (add (% 1) (+ src))
	            (add (% 1) (+ dst))
	            (add (% 8) (+ bomb))
	            (mov (% 0) (^ bomb))
	            (jmp (+ loop))
	(label done)(mov (% 4) (^ dst))
	            (mov (% 191) (+ 182))
	            (jmp (+ 182))
	(label bomb)(dat (% 4))))

(define (make-stomper)
  (make-program 'stomper 2 stomper-text (rca stomper-text)))

;;
;; Something of my own creation.
;;
(define vandal-text
  '((label loop) (split (+ imp))
	             (jmp (+ loop))
	(label imp)  (mov (+ 0) (+ 1))))

(define (make-vandal)
  (make-program 'Vandal 0 vandal-text (rca vandal-text)))

(define imp-gun-text
  '((label imps) (mov (% 0) (+ -1))
				 (jmp (+ imps))
	(label start)(spl (+ imps))
				 (jmp (+ loop))
	(label count)(dat (% 7))
	(label ptr)  (dat (% 57))
				 (mov (% 7) (+ count))
				 (mov (% 57) (+ ptr))
	(label loop) (mov (^ count) (^ ptr))
				 (sub (% 1) (+ ptr))
				 (djnz (+ count) (+ loop))	;; reversed from CP's version
				 (jmp (+ 46))))

(define (make-imp-gun)
  (make-program 'Imp-gun 2 imp-gun-text (rca imp-gun-text)))

(define *combatants*
  (list (cons "dwarf" make-dwarf) (cons "imp" make-imp)
		(cons "gemini" make-gemini) (cons "stomper" make-stomper)
		(cons "vandal" make-vandal) (cons "imp-gun" make-imp-gun)))
