;;
;; no-print.scm
;;
;; Terse printer for execution
;;

(module print)
(include "cw.sch")

(define last-round 0)

(define (terse-print-execution round p i ma oa ea mb ob eb)
  (if (and (not (= last-round round)) (= 0 (remainder round 50)))
      (begin (format #t "~s " round) (set! last-round round)
      (flush-output-port))))

(define (terse-display-init programs)
  #t)

(define (mode->string m) (vector-ref '#("+" "^" "%" "<") m))

(define (print-operand m o e)
  (format #t " ~a~a" (mode->string m) o)
  (if (= m 1)
      (format #t "(~a)" (e 'address))))

(define (verbose-print-execution round p i mode-a op-a effective-a
			 mode-b op-b effective-b)
  (if (not (= last-round round))
      (begin (newline) (set! last-round round)))
  (format #t "~a[~a] ~a: ~a" (program-name p) (current-pc-number p)
			     (current-pc p) (i 'name))
  (if (> (i 'n-ops) 0)
      (print-operand mode-a op-a effective-a))
  (if (> (i 'n-ops) 1)
      (print-operand mode-b op-b effective-b))
  (display #\tab)
  (if *single-stepping*
      (begin
	(display "hit any key to continue: ")
	(read-char)
	(newline))))

(define *the-programs* #f)
(define *single-stepping* #f)

(define (verbose-display-init programs)
;  (let ((index 0))
;    (set! *the-programs*
;	  (map (lambda (p)
;		 (let ((new-car (cons (program-name p) index)))
;		   (set! index (inc index))
;		   new-car))
;	       programs))))
#t)

(define *verbose-print* #f)

(define (display-init p)
  (if *verbose-print*
      (verbose-display-init p)
      (terse-display-init p)))

(define (print-execution r p i ma oa ea mb ob eb)
  (if *verbose-print*
      (verbose-print-execution r p i ma oa ea mb ob eb)
      (terse-print-execution r p i ma oa ea mb ob eb)))
