;;
;; Main driver for Scheme->C version of Core War.
;;

(module cw (main start)
	(with mars util rcasm program redcode core instr print))

(include "cw.sch")

(define limit #f)

(define-external (clock) util)

(define (start args)
  (display "Core Wars (Scheme->C) -- Sept 1990 Sam Shen") (newline)
  (set! print-execution terse-execution-printer)
  (set! display-init terse-display-init)
  (call-with-current-continuation
   (lambda (return)
     (if (< (length args) 3)
	 (begin (format #t "Usage: ~a [-v] limit program1 ...~%" (car args))
		(return 0)))
     (if (equal? (cadr args) "-v")
	 (begin
	   (set! *verbose-print* #t)
	   (set! args (cdr args))))
     (set! limit (string->number (cadr args)))
     (if (or (not limit) (< limit 1))
	 (begin (display "Limit should be non-zero.") (newline) (return 0)))
     (let loop ((programs '())
		(argl (cddr args)))
       (if argl
	   (let ((maker (assoc (car argl) *combatants*)))
	     (if maker
		 (begin (format #t "Making: ~a~%" (car argl))
			(loop (cons ((cdr maker)) programs) (cdr argl)))
		 (begin (display "Program not found: ") (display (car argl))
			(newline) (return 1))))

	   (begin
	     (display "Making a core . . .") (flush-output-port)
	     (let ((the-core (make-core)))
	       (display " done.") (newline)
	       (let ((start (clock)))
		 (mars programs the-core limit)
		 (let* ((end (clock))
			(total (- end start)))
		   (format
		    #t
		    "Executed ~s instructions in ~s seconds (~s instr/sec)~%"
		    *n-instr-executed* total (/ *n-instr-executed* total)))))))))))
