;;
;; cs-print.scm
;;
;; This is a game execution printer for MIT C-Scheme 7.0's X11 graphics.
;; It used to work ... that's about all I can say.
;;

(declare (usual-integrations))

(define device #f)
(define *x-display* "unix:0.0")

(define *program-1* #f)
(define *program-2* #f)

(define (triangle x y)
  (let* ((ax (+ x .1))
	 (ay (+ y .1))
	 (bx (+ ax .4))
	 (by (+ ay .69))
	 (cx (+ ax .8))
	 (cy ay))
    (graphics-draw-line device ax ay bx by)
    (graphics-draw-line device ax ay cx cy)
    (graphics-draw-line device bx by cx cy)))

(define (box x y)
  (let* ((ax (+ x .1))
	 (ay (+ y .1))
	 (bx ax)
	 (by (+ ay .8))
	 (cx (+ ax .8))
	 (cy by)
	 (dx cx)
	 (dy ay))
  (graphics-draw-line device ax ay bx by)
  (graphics-draw-line device ax ay dx dy)
  (graphics-draw-line device bx by cx cy)
  (graphics-draw-line device cx cy dx dy)))

(define (x-marks-the-spot x y)
  (let ((ax (+ x .1))
	(ay (+ y .1))
	(bx (+ x .8))
	(by (+ y .8)))
    (graphics-draw-line device ax ay bx by)
    (graphics-draw-line device ax by bx ay)))

(define (draw-hash-lines)
  (define (iter y)
    (if (<= y 64)
	(begin
	  (graphics-draw-line device 0 y 64 y)
	  (graphics-draw-line device y 0 y 64)
	  (iter (1+ y)))))
  (iter 0))

(define (print-execution p i mode-a op-a effective-a mode-b op-b effective-b)
  (let ((program-1? (eq? p *program-1*)))
;;    (if program-1? (set-color "green") (set-color "red"))
    (if (> (i 'n-ops) 0)
	(show-op mode-a effective-a
		 (if program-1? box triangle)))
    (if (> (i 'n-ops) 1)
	(show-op mode-b effective-b
		 (if program-1? box triangle)))))

(define (show-op mode op marker)
  (if (not (= 2 mode))
      (let ((addr (op 'address)))
	(marker (remainder addr 64)
		(- 63 (truncate (/ addr 64)))))))

(define (set-color c)
  (graphics-operation device 'set-foreground-color c))

(define graphics-init
  (lambda ()
    (if device
	(graphics-close device))
    (set! device (make-graphics-device x-graphics-device-type *x-display*
				       (x-geometry-string #f #f 640 640)))
    (graphics-set-coordinate-limits device 0 0 64 64)
    (graphics-set-clip-rectangle device 0 0 64 64)
    (graphics-operation device 'set-background-color "black")
    (graphics-operation device 'set-foreground-color ;;"blue"
			"white")
    (graphics-operation device 'set-mouse-color "white")
    (graphics-clear device)
;;    (graphics-bind-line-style device 2 draw-hash-lines)))
    (draw-hash-lines)
    (display "Press any key to begin: ")
    (read-char)
    (newline)))

(define (display-init programs)
  (graphics-init)
  (set! *program-1* (car programs))
  (set! *program-2* (cadr programs)))
