; -*- Scheme -*-
;
; $Id$

;+doc
; procedure: char-set:equal?
; arguments: a b
; signature: char-set x char-set -> bool
;
; Determines if the two char-sets are equal i.e. contain the same characters.
;-doc

(define char-set:equal?
  (lambda (a b)
    (let loop ((i (- char-set::vector-size 1))
	       (r (= (char-set:size a) (char-set:size b))))
      (cond
       ((zero? i) r)
       ((not r) r)
       (else (loop (- i 1) (eq? (char-set::at a i) (char-set::at b i))))))))

; eof
