; -*- Scheme -*-
;
; $Id$

(require 'char-set:make)
(require 'char-set::1+size!)

;+doc
; procedure: char-set:from-integer-range
; arguments: lower-bound upper-bound
; signature: int x int -> char-set
; pre:       (<= 0 lower-bound upper-bound 255)
;
; Creates a new char-set containing the characters whose ASCII code
; lies between LOWER-BOUND and UPPER-BOUND inclusive
;-doc


(define char-set:from-integer-range
  (lambda (lb ub)
    (let ((r (char-set:make))
	  (ep (+ 2 ub)))
      (let loop ((i (+ 1 lb)))
	(if (= i ep)
	    r
	    (begin
	      (vector-set! r i #t)
	      (char-set::1+size! r)
	      (loop (+ 1 i))))))))

; eof
