; -*- Scheme -*-
;
; $Id$

(require 'char-set::at)
(require 'char-set::1+size!)

;+doc
; procedure: char-set:insert!
; arguments: char-set char
; signature: char-set x char -> unspecified
;
; Modifies CHAR-SET so that it contains CHAR
;-doc

(define char-set:insert!
  (lambda (s c)
    (let ((i (+ 1 (char->integer c))))
      (if (not (char-set::at s i))
	  (char-set::1+size! s))
      (vector-set! s i #t))))

; eof
