; -*- Scheme -*-
;
; $Id$

(require 'char-set:make)
(require 'char-set::1+size!)

;+doc
; procedure: char-set:from-range
; arguments: lower-bound upper-bound
; signature: int x int -> char-set
; pre:       (<= lower-bound upper-bound 255)
;
; Creates a new char-set containing all the characters whose ASCII
; value lies between LOWER-BOUND and UPPER-BOUND inclusive.
;-doc

(define char-set:from-range
  (lambda (lb ub)
    (let ((r (char-set:make))
	  (ep (+ 2 (char->integer ub))))
      (let loop ((p (+ 1 (char->integer lb))))
	(if (= p ep)
	    r
	    (begin
	      (vector-set! r p #t)
	      (char-set::1+size! r)
	      (loop (+ 1 p))))))))

; eof
