;; -*- Scheme -*-
;;
;; $Id: avl-tree12.scm,v 1.2 1993/10/27 15:40:56 bevan Exp $

;;-----------

(require 'avl-tree:nil?)
(require 'avl-tree::left)
(require 'avl-tree::right)
(require 'avl-tree::data)

;;-----------

;;+doc
;; procedure: avl-tree->list-in-order
;; arguments: tree
;; signature: forall a,b,c => avl-tree[a,b,c] -> [c]
;;
;; Convert the AVL TREE into a list whilst preserving the order.
;;-doc

(define avl-tree->list-in-order
  (lambda (t)
    (let loop ((t t) (r '()))
      (if (avl-tree:nil? t)
	  r
	  (loop (avl-tree::left t)
		(cons (avl-tree::data t) (loop (avl-tree::right t) r)))))))

;; eof
