;; -*- Scheme -*-
;;
;; $Id: avl-tree09.scm,v 1.2 1993/10/27 15:43:13 bevan Exp $

;;------------

(require 'avl-tree:nil?)
(require 'avl-tree::left)
(require 'avl-tree::right)
(require 'avl-tree::data)

;;------------

;;+doc
;; procedure: avl-tree:for-each-in-order
;; arguments: tree action[left key&data next] state
;; signature: forall a,b,c => avl-tree[a,b,c] x (d x c x (d -> d) -> d) x d
;;                         -> d
;;
;; Applies ACTION to each KEY&DATA element in TREE in order, but requires
;; NEXT to be called to drive the computation. 
;;-doc

(define avl-tree:for-each-in-order
  (lambda (t f s)
    (if (avl-tree:nil? t)
	s
	(let ((lr (avl-tree:for-each-in-order (avl-tree::left t) f s))
	      (r  (lambda (s)
		    (avl-tree:for-each-in-order (avl-tree::right t) f s))))
	  (f lr (avl-tree::data t) r)))))

;; eof
