#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; User Interface

(declare (usual-integrations make-cell))

(define (make-constraint type)
  (let ((constraint (*make-constraint type)))
    (run!)
    constraint))

(define (make-variable name)
  (make-cell name false))

(define (== x y)
  (equate! x y)
  (run!))

(define (disequate x y)
  (*disequate! x y)
  (run!))

(define (detach cell)
  (*detach! cell)
  (run!))

(define (disconnect cell)
  (*disconnect! cell)
  (run!))

(define (dissolve cell)
  (*dissolve! cell)
  (run!))

(define (retract cell)
  (*retract! (cell/true-supplier cell))
  (run!))

(define (change cell value)
  (*change! cell value)
  (run!))

(define (disallow . cells)
  (*disallow! cells)
  (run!))

(define (make-constant contents)
  (make-initialized-cell 'CONSTANT constant-rule contents))

(define (make-default contents)
  (make-initialized-cell 'DEFAULT default-rule contents))

(define (make-parameter contents)
  (make-initialized-cell 'PARAMETER parameter-rule contents))

(define (make-assumption value)
  (let ((constraint (*make-constraint assumption)))
    (set-constraint/info! constraint value)
    (run!)
    (constraint/cell constraint 'PIN)))

(define (make-oneof values)
  (let ((constraint (*make-constraint oneof)))
    (set-constraint/info! constraint values)
    (run!)
    (constraint/cell constraint 'PIN)))

(define (make-firstoneof values)
  (let ((constraint (*make-constraint firstoneof)))
    (set-constraint/info! constraint values)
    (run!)
    (constraint/cell constraint 'PIN)))