'From Smalltalk-80, Version 2.2 of July 4, 1987 on 13 February 1989 at 4:27:44 pm'!



!Inspector methodsFor: 'field list'!

fieldMenu
	"Inspector flushMenus"
	field == nil ifTrue:
		[^ ActionMenu
			labels: 'update'
			selectors: #(update)].
	ListMenu == nil ifTrue:
		[ListMenu _ ActionMenu
			labels: 'inspect\update' withCRs
			selectors: #(inspectField update)].
	^ ListMenu! !


!Inspector methodsFor: 'updating'!

update
	"Reshow contents, assuming selected value may have changed"
	self changed: #field.
	field ~~ nil ifTrue: [self changed: #text]! !



DictionaryInspector subclass: #VariableDictionaryInspector
	instanceVariableNames: 'varField '
	classVariableNames: 'KeyListMenu VarListMenu '
	poolDictionaries: ''
	category: 'Interface-Inspector'!


!VariableDictionaryInspector methodsFor: 'field list'!

field: selection
	field _ selection.
	(field ~~ nil) & (varField ~~ nil) ifTrue:
		[varField _ nil.
		^ self changed: #varField].
	self changed: #text! !

!VariableDictionaryInspector methodsFor: 'var field list'!

printVarItems
	^ false!

varField
	^ varField!

varField: selection
	varField _ selection.
	(field ~~ nil) & (varField ~~ nil) ifTrue:
		[field _ nil.
		^ self changed: #field].
	self changed: #text!

varFieldIndex
	"Answer the offset corresponding to the currently selected varField."

	varField first isDigit
		ifTrue: [^ Integer readFromString: varField]
		ifFalse: [^ object class allInstVarNames indexOf: varField]!

varFieldList
	"Answer an Array consisting of 'self' and the instance variable names of the inspected object."
	^ (Array with: 'self'), object class allInstVarNames!

varFieldMenu
	"VariableDictionaryInspector flushMenus"
	varField == nil ifTrue:
		[^ ActionMenu
			labels: 'update'
			selectors: #(update)].
	VarListMenu == nil ifTrue:
		[VarListMenu _ ActionMenu
			labels: 'inspect\update' withCRs
			selectors: #(inspectField update)].
	^ VarListMenu!

varFieldValue

	varField = 'self' ifTrue: [^object].
	varField first isDigit
		ifTrue: [^object basicAt: self varFieldIndex]
		ifFalse: [^object instVarAt: self varFieldIndex]! !

!VariableDictionaryInspector methodsFor: 'text'!

text
	varField ~~ nil
		ifTrue: [^ self varFieldValue printString asText].
	field ~~ nil
		ifTrue: [^ self fieldValue printString asText].
	^ Text new! !

!VariableDictionaryInspector methodsFor: 'doit/accept/explain'!

acceptText: aText from: aController
	| val |
	object class == CompiledMethod
		ifTrue: [^false].
	(varField == nil) & (field == nil) ifTrue: [^false].
	val _ self evaluateText: aText string from: aController ifFail: [^ false].
	varField ~~ nil
		ifTrue: [object instVarAt: self varFieldIndex put: val]
		ifFalse: [object basicAt: self fieldIndex put: val].
	self changed: #text.
	^ true! !

!VariableDictionaryInspector methodsFor: 'updating'!

update
	self changed: #varField.
	self changed: #field.
	self changed: #text! !

!VariableDictionaryInspector methodsFor: 'menu commands'!

inspectField
	varField ~~ nil
		ifTrue: [self varFieldValue inspect]
		ifFalse: [self fieldValue inspect]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VariableDictionaryInspector class
	instanceVariableNames: ''!


!VariableDictionaryInspector class methodsFor: 'initialization'!

flushMenus
	VarListMenu _ DictListMenu _ TextMenu _ nil! !

!VariableDictionaryInspector class methodsFor: 'instance creation'!

inspector: anInspector 
	"Answer an instance of me on the model, anInspector.
	Label and minimum size are not set."

	| anInspectorView |
	anInspectorView _ VariableDictionaryInspectorView new.
	anInspectorView model: anInspector.
	self view: anInspector in: (0@0 extent: 1@1) of: anInspectorView.
	^anInspectorView! !



InspectorView subclass: #VariableDictionaryInspectorView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Interface-Inspector'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

VariableDictionaryInspectorView class
	instanceVariableNames: ''!


!VariableDictionaryInspectorView class methodsFor: 'instance creation'!

inspector: anInspector 
	"Answer an instance of me on the model, anInspector.
	Label and minimum size are not set."

	| anInspectorView |
	anInspectorView _ VariableDictionaryInspectorView new.
	anInspectorView model: anInspector.
	self view: anInspector in: (0@0 extent: 1@1) of: anInspectorView.
	^anInspectorView!

view: anInspector in: area of: superView
	"Create proportioned List and Code views on anInspector in area of superView"

	| x1 x2 x3 y1 y2 y3 |
	x1 _ area left.
	x2 _ x1 + (area width * 0.3).
	x3 _ area width - x2.
	y1 _ area top.
	y2 _ y1 + (area height * 0.5).
	y3 _ area height - y2.
	superView addSubView:
		(SelectionInListView
			on: anInspector printItems: anInspector printVarItems
			oneItem: false aspect: #varField change: #varField: list: #varFieldList
			menu: #varFieldMenu initialSelection: #varField)
		in: (x1@y1 extent: x2@y2) borderWidth: 1.
	superView addSubView:
		(SelectionInListView
			on: anInspector printItems: anInspector printItems
			oneItem: false aspect: #field change: #field: list: #fieldList
			menu: #fieldMenu initialSelection: #field)
		in: (x1@y2 extent: x2@y3) borderWidth: 1.
	superView addSubView: (CodeView on: anInspector aspect: #text
			change: #acceptText:from:
			menu: #textMenu initialSelection: nil)
		in: (x2@y1 extent: x3@area height) borderWidth: 1! !



!DictionaryInspector methodsFor: 'field list'!

fieldMenu
	"DictionaryInspector flushMenus" 

	field == nil ifTrue:
		[^ActionMenu labels: 'add field\update' withCRs
			lines: #(1)
			selectors: #(addField update)].
	DictListMenu == nil ifTrue:
		[DictListMenu _ ActionMenu
			labels: 'inspect\references\add field\remove\update' withCRs
			lines: #(2 4)
			selectors: #(inspectField browseReferences
						addField removeField update)].
	^DictListMenu! !


!Dictionary methodsFor: 'user interface'!

inspect
	"Create and schedule a DictionaryInspector in which the user can examine the
	receiver's variables."

	Cursor wait showWhile: [VariableDictionaryInspectorView open: (VariableDictionaryInspector inspect: self)]! !
