MouseMenuController subclass: #DrawingController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Model Builder'!


!DrawingController methodsFor: 'figure deletion'!

deleteFigure
| point figure|
	point _ self localCursorPoint.
	figure _ model figureAt: point.
	figure isNil
		ifFalse: 
			[self view delete: figure]! !

!DrawingController methodsFor: 'figure colouring'!

paintFigure
	| point figure colour rectangle |
	point _ self localCursorPoint.
	figure _ model figureAt: point.
	figure isNil
		ifFalse: 
			[colour _ FillInTheBlank request: 'What colour do you want ?'.
			figure colour: colour.
			view displayFigureAsShape: figure]! !

!DrawingController methodsFor: 'control activity'!

changeColour
|aFigure aPoint|
aPoint _ self localCursorPoint.
aFigure _ model figureAt: aPoint.
aFigure isNil ifTrue: [nil] ifFalse: [self paintFigure: aFigure]!

controlActivity
sensor redButtonPressed ifTrue: [self moveOrCreateRectangle].
(sensor redButtonPressed & sensor leftShiftDown) ifTrue: [self createForm].
super controlActivity!

createForm
|point figure|
point _ self localCursorPoint.
figure _ model figureAt: point.
figure isNil ifTrue: [self createFormAt: point] ifFalse: [self moveFigure: figure]!

moveOrCreateRectangle
| point figure|
point _ self localCursorPoint.
figure _ model figureAt: point.
figure isNil ifTrue: [self createBoxAt: point] ifFalse: [self moveFigure: figure]! !

!DrawingController methodsFor: 'figure creation'!

createBoxAt: aPoint 
|aFigure|
aFigure _ Figure rectangle: (aPoint extent: 1@1).
aFigure origin: aPoint.
model add: aFigure. 
self growBox: aFigure.
aFigure setShape: (Form fromDisplay: aFigure contour) .!

createFormAt: aPoint
|aFigure|
aFigure _ Figure makeShapeAt: aPoint.
aFigure origin: aPoint.
model add: aFigure! !

!DrawingController methodsFor: 'figure animation'!

changing: aFigure track: aBlock
|oldPoint newPoint aRectangle|
oldPoint _ self localCursorPoint.
[sensor redButtonPressed] whileTrue: [(newPoint _ self localCursorPoint) ~= oldPoint ifTrue: [aRectangle _ aFigure displayBox.
aBlock value: newPoint - oldPoint.
aRectangle _ aRectangle merge: aFigure displayBox.
view display: aRectangle. 
oldPoint _ newPoint]]!

moveFigure: aFigure
self changing: aFigure track: [:delta| aFigure moveBy: delta].
aFigure setShape: (Form fromDisplay: aFigure contour).! !

!DrawingController methodsFor: 'cursor control'!

localCursorPoint
^view inverseDisplayTransform: sensor cursorPoint! !

!DrawingController methodsFor: 'initialization'!

initialize
super initialize.
self yellowButtonMenu: (PopUpMenu labels: 'colour\delete' withCRs)
	yellowButtonMessages: #(paintFigure deleteFigure)! !

!DrawingController methodsFor: 'figure transforms'!

growBox: aFigure
self changing: aFigure track: [:delta | aFigure growBy: delta]! !

View subclass: #DrawingView
	instanceVariableNames: 'backgroundColour '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Model Builder'!


!DrawingView methodsFor: 'private'!

computeDisplayTransformation
"override the relevant View method to prevent scaling (only translation is required to see more of a picture)"
^WindowingTransformation scale: nil translation: super computeDisplayTransformation translation rounded! !

!DrawingView methodsFor: 'display'!

display: aRectangle
|aForm|
aForm _ Form extent: aRectangle extent.
aForm fill: aForm computeBoundingBox rule: Form over mask: (Form perform: self backgroundColour asSymbol).
model displayOn: aForm at: aRectangle origin * -1 clippingBox: aRectangle.
aForm displayOn: Display at: self insetDisplayBox origin + aRectangle origin clippingBox: self insetDisplayBox.!

displayFigureAsShape: aFigure
aFigure shape shapeFill: (Form perform: aFigure colour asSymbol) interiorPoint: aFigure contour center.
model displayOn: aFigure shape at: aFigure origin * -1 clippingBox: aFigure shape computeBoundingBox.
aFigure shape displayOn: Display at: self insetDisplayBox origin + aFigure origin clippingBox: self insetDisplayBox!

displayView
self display: (self inverseDisplayTransform: self insetDisplayBox)! !

!DrawingView methodsFor: 'default controller'!

defaultControllerClass
^DrawingController! !

!DrawingView methodsFor: 'access'!

backgroundColour
^backgroundColour!

backgroundColour: aString
backgroundColour _ aString! !

!DrawingView methodsFor: 'figure deletion'!

delete: aFigure
model remove: aFigure.
aFigure shape perform: (self backgroundColour) asSymbol.
model displayOn: aFigure shape at: aFigure origin * -1 clippingBox: aFigure shape computeBoundingBox.
aFigure shape displayOn: Display at: self insetDisplayBox origin + aFigure origin clippingBox: self insetDisplayBox.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DrawingView class
	instanceVariableNames: ''!


!DrawingView class methodsFor: 'creation'!

openOn: aDrawing
|topView subView|
subView _ self new model: aDrawing.
subView borderWidth: 0.
subView backgroundColour: 'white'.
subView insideColor: Form white.
subView controller: DrawingController new initialize.
topView _ StandardSystemView new.
topView borderWidth: 1; label: 'Micro Draw'.
topView addSubView: subView in: (0@0 extent: 1@1) borderWidth: 1.
topView controller open! !

Object subclass: #Drawing
	instanceVariableNames: 'figures '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Model Builder'!


!Drawing methodsFor: 'display'!

displayOn: aDisplayMedium at: aPoint  clippingBox: aRectangle
(self figuresIntersecting: aRectangle) reverseDo: [:each| each displayOn: aDisplayMedium at: aPoint clippingBox: aRectangle].!

figuresIntersecting: aRectangle
^ figures select: [:each| each intersects: aRectangle]! !

!Drawing methodsFor: 'initialization'!

initialize
figures _ OrderedCollection new!

open
DrawingView openOn: self! !

!Drawing methodsFor: 'selection'!

figureAt: aPoint
^ figures detect: [:each | each containsPoint: aPoint] ifNone: [nil]! !

!Drawing methodsFor: 'access'!

add: aFigure
figures addFirst: aFigure!

remove: aFigure
figures remove: aFigure ifAbsent: [Transcript show: '*** ERROR:  non-existent figure !!'; cr]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Drawing class
	instanceVariableNames: ''!


!Drawing class methodsFor: 'creation'!

new
^super new initialize! !

Object subclass: #Figure
	instanceVariableNames: 'origin contour shape colour '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Model Builder'!


!Figure methodsFor: 'display'!

displayBox 
^ self contour!

displayOn: aDisplayMedium at: aPoint clippingBox: aRectangle
aDisplayMedium perform: (colour append: ':') asSymbol with: ((self displayBox intersect: aRectangle) translateBy: aPoint).!

intersects: aRectangle
^self displayBox intersects: aRectangle! !

!Figure methodsFor: 'private'!

setShape: aForm
shape _ aForm! !

!Figure methodsFor: 'access'!

colour: aString
colour _ aString!

contour: aRectangle
contour _ aRectangle!

origin: aPoint
origin _ aPoint! !

!Figure methodsFor: 'query'!

colour
^colour!

contour
^ contour!

origin
^origin!

shape
^shape! !

!Figure methodsFor: 'selection'!

containsPoint: aPoint
^self displayBox containsPoint: aPoint! !

!Figure methodsFor: 'animation'!

moveBy: aPoint
contour _ contour translateBy: aPoint! !

!Figure methodsFor: 'transformation'!

growBy: aPoint
contour _ contour origin extent: contour extent + aPoint! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Figure class
	instanceVariableNames: ''!


!Figure class methodsFor: 'creation'!

makeShapeAt: aPoint
|candidate|
candidate _ self new.
candidate origin: aPoint.
[candidate setShape: (Form extent: 16@16) bitEdit] forkAt: 4.
candidate contour: (Rectangle origin: aPoint extent: 16@16). 
candidate colour: 'black'.
Processor yield.
^ candidate!

rectangle: aRectangle
|candidate|
candidate _ self new.
candidate origin: aRectangle origin.
candidate setShape: (Form extent: aRectangle extent).
candidate contour: aRectangle.
candidate colour: 'black'.
^ candidate! !