; test of monkey and banana microworld
;

! (SetUpMonkey)
! (define *g (GetGoalFN Monkey-SearchProblem))

= (*g '(atdoor onfloor atwindow))
  #f

= (*g '(underbanana onbox underbanana))
  #t

! (define *e (GetEvalFN Monkey-SearchProblem))

= (*e '(atdoor onfloor atwindow))
  -3

= (*e '(underbanana onbox underbanana))
  3

! (define *mleft (FirstAction (GetActions Monkey-SearchProblem)))

; unable to move left if at door
= (*mleft '(atdoor onfloor atwindow))
  #f

; unable to move if on box
= (*mleft '(underbanana onbox underbanana))
  #f
  
= (*mleft '(underbanana onfloor underbanana))
  (atdoor onfloor underbanana)
  
= (DFSearch Monkey-SearchProblem 2)
  #f

= (DFSearch Monkey-SearchProblem 5)
  (5 30 (#(ok NEG-INFINITY (underbanana onbox underbanana))
         #(ok NEG-INFINITY (underbanana onfloor underbanana))
         #(ok NEG-INFINITY (atwindow onfloor atwindow))
         #(ok NEG-INFINITY (underbanana onfloor atwindow))
         #(ok NEG-INFINITY (atdoor onfloor atwindow))))
  
= (DFSearch Monkey-SearchProblem 10)
  (5 42 (#(ok NEG-INFINITY (underbanana onbox underbanana))
         #(ok NEG-INFINITY (underbanana onfloor underbanana))
         #(ok NEG-INFINITY (atwindow onfloor atwindow))
         #(ok NEG-INFINITY (underbanana onfloor atwindow))
         #(ok NEG-INFINITY (atdoor onfloor atwindow))))
  
= (BFSearch Monkey-SearchProblem)
  (5 42 (#(ok NEG-INFINITY (underbanana onbox underbanana))
         #(ok NEG-INFINITY (underbanana onfloor underbanana))
         #(ok NEG-INFINITY (atwindow onfloor atwindow))
         #(ok NEG-INFINITY (underbanana onfloor atwindow))
         #(ok NEG-INFINITY (atdoor onfloor atwindow))))
  
= (HillSearch Monkey-SearchProblem 2)
  #f

= (HillSearch Monkey-SearchProblem 5)
  (5 30 (#(ok 3 (underbanana onbox underbanana))
         #(ok 1 (underbanana onfloor underbanana))
         #(ok -1 (atwindow onfloor atwindow))
         #(ok -1 (underbanana onfloor atwindow))
         #(ok -3 (atdoor onfloor atwindow))))
  
= (HillSearch Monkey-SearchProblem 10)
  (5 30 (#(ok 3 (underbanana onbox underbanana))
         #(ok 1 (underbanana onfloor underbanana))
         #(ok -1 (atwindow onfloor atwindow))
         #(ok -1 (underbanana onfloor atwindow))
         #(ok -3 (atdoor onfloor atwindow))))
  
= (SteepestSearch Monkey-SearchProblem)
  (5 24 (#(ok 3 (underbanana onbox underbanana))
         #(ok 1 (underbanana onfloor underbanana))
         #(ok -1 (atwindow onfloor atwindow))
         #(ok -1 (underbanana onfloor atwindow))
         #(ok -3 (atdoor onfloor atwindow))))