; test of 8-puzzle microworld
;

! (SetUp8Puzzle)
! (define *g (GetGoalFN 8-SearchProblem))

= (*g '(2 8 3 1 6 4 7 e 5))
  #f

= (*g '(1 2 3 8 e 4 7 6 5))
  #t

! (define *e (GetEvalFN 8-SearchProblem))

= (*e '(2 8 3 1 6 4 7 e 5))
  -5

= (*e '(1 2 3 8 e 4 7 6 5))
  0

! (define *up (FirstAction (GetActions 8-SearchProblem)))

= (*up '(2 8 3 1 6 4 7 e 5))
  (2 8 3 1 e 4 7 6 5)

; next gives #f as empty tile moves off top
= (*up (*up (*up '(2 8 3 1 6 4 7 e 5))))
  #f

= (DFSearch 8-SearchProblem 2)
  #f

= (DFSearch 8-SearchProblem 10)
  (6 52 (#(ok NEG-INFINITY (1 2 3 8 e 4 7 6 5))
         #(ok NEG-INFINITY (1 2 3 e 8 4 7 6 5))
         #(ok NEG-INFINITY (e 2 3 1 8 4 7 6 5))
         #(ok NEG-INFINITY (2 e 3 1 8 4 7 6 5))
         #(ok NEG-INFINITY (2 8 3 1 e 4 7 6 5))
         #(ok NEG-INFINITY (2 8 3 1 6 4 7 e 5))))
  
= (BFSearch 8-SearchProblem)
  (6 136 (#(ok NEG-INFINITY (1 2 3 8 e 4 7 6 5))
          #(ok NEG-INFINITY (1 2 3 e 8 4 7 6 5))
          #(ok NEG-INFINITY (e 2 3 1 8 4 7 6 5))
          #(ok NEG-INFINITY (2 e 3 1 8 4 7 6 5))
          #(ok NEG-INFINITY (2 8 3 1 e 4 7 6 5))
          #(ok NEG-INFINITY (2 8 3 1 6 4 7 e 5))))
  
= (HillSearch 8-SearchProblem 2)
  #f

= (HillSearch 8-SearchProblem 10)
  (6 20 (#(ok 0 (1 2 3 8 e 4 7 6 5))
         #(ok -1 (1 2 3 e 8 4 7 6 5))
         #(ok -2 (e 2 3 1 8 4 7 6 5))
         #(ok -3 (2 e 3 1 8 4 7 6 5))
         #(ok -4 (2 8 3 1 e 4 7 6 5))
         #(ok -5 (2 8 3 1 6 4 7 e 5))))
  
= (SteepestSearch 8-SearchProblem)
  (6 20 (#(ok 0 (1 2 3 8 e 4 7 6 5))
         #(ok -1 (1 2 3 e 8 4 7 6 5))
         #(ok -2 (e 2 3 1 8 4 7 6 5))
         #(ok -3 (2 e 3 1 8 4 7 6 5))
         #(ok -4 (2 8 3 1 e 4 7 6 5))
         #(ok -5 (2 8 3 1 6 4 7 e 5))))