; ********** Missionaries and Cannibals Problem ************
; This is a problem involving 3 missionaries and 3 cannibals
; who wish to cross a river in a boat. The boat requires at
; least one person to row it but can optionally carry one
; additional person. The problem is made more interesting by
; requiring that the missionaries are never outnumbered by
; the cannibals on a bank if they are to avoid being
; consumed.

(define MC-SearchProblem #f)

(define SetUpMC
  (lambda ()
    
    ; represent the state of the world as a list consisting
    ; of the left and right bank respectively. Use 'm', 'c'
    ; and 'b' to represent the presence of missionaries,
    ; cannibals and boat on a bank without regard to order.
    ; The following functions construct and manipulate
    ; states and sets.
    
    (define leftBank
      (lambda (aState) (car aState)))
    (define rightBank
      (lambda (aState) (cadr aState)))
    (define numberOf
      (lambda (aSym aSet)
        ; return number of occurences in aSet of aSym
        (set! aSet (memq aSym aSet))
        (if (not aSet)
            0
            (+ 1 (numberOf aSym (cdr aSet))))))
    (define contains?
      (lambda (aSet1 aSet2)
        ; is aSet1 contained in aSet2?
        (and (<= (numberOf 'm aSet1) (numberOf 'm aSet2))
             (<= (numberOf 'c aSet1) (numberOf 'c aSet2))
             (<= (numberOf 'b aSet1) (numberOf 'b aSet2)))))
    (define set=
      (lambda (aSet1 aSet2)
        (and (= (numberOf 'm aSet1) (numberOf 'm aSet2))
             (= (numberOf 'c aSet1) (numberOf 'c aSet2))
             (= (numberOf 'b aSet1) (numberOf 'b aSet2)))))
    (define set+
      (lambda (aSet1 aSet2)
        ; return the sum of the sets
        (append aSet1 aSet2)))
    (define set-
      (lambda (aSet1 aSet2)
        ; Return the difference of the sets
        ; ( aSet2 - aSet1 )
        (define remove
          (lambda (aSym aSet)
            ; remove first occurrance (if any) of aSym from
            ; aSet
            (cond ((null? aSet) ())
                  ((eq? aSym (car aSet)) (cdr aSet))
                  (else (cons (car aSet)
                              (remove aSym (cdr aSet)))))))
        (if (null? aSet1)
            aSet2
            (set- (cdr aSet1) (remove (car aSet1) aSet2)))))
    
    ; when a new state is created, check for cannibalism.
    
    (define makeState
      (lambda (left right)
        
        (define outnumbered?
          (lambda (aSet)
            ; are the missionaries outnumbered by cannibals?
            (and (< 0 (numberOf 'm aSet))
                 (< (numberOf 'm aSet)
                    (numberOf 'c aSet)))))
        
        (if (or (outnumbered? left)
                (outnumbered? right))
            #f
            (list left right))))
    
    ; need special test for state equality as order in state
    ; is not significant
    
    (define sameWorld?
      (lambda (aState1 aState2)
        (if (not aState1)
            (not aState2)
            (and (set= (leftBank aState1)
                       (leftBank aState2))
                 (set= (rightBank aState1)
                       (rightBank aState2))))))
    
    (define printWorld
      (lambda (aState)
        (if (null? aState)
            (display "[ || ]")
            (begin (display "[")
                   (display (leftBank aState))
                   (display "||")
                   (display (rightBank aState))
                   (display "]")))))
        
    ; If they start on the left bank the initial state is:
    
    (define initialState '((m m m c c c b) ()))
    
    ; the goal is to get them all to the other bank (without
    ; anyone being eaten) so the goal function is:
    
    (define goalFN
      (lambda (aState)
        (contains? '(m m m c c c) (rightBank aState))))
    
    ; the actions possible are to move either one or two
    ; people from the bank where the boat is moored to the
    ; other one.
    
    (define moveSet
      (lambda (aSet)
        ; This function returns a function to attempt to
        ; move the people in the set aSet from the bank
        ; where the boat is moored to the other.
        (lambda (aState)
          (let ((newSet (set+ '(b) aSet)))
            (if (contains? '(b) (leftBank aState))
                ; boat is at left bank - try to move people
                ; to right
                (if (contains? newSet (leftBank aState))
                    (makeState
                     (set- newSet (leftBank aState))
                     (set+ newSet (rightBank aState)))
                    #f)
                ; boat is at right bank - try to move people
                ; to left
                (if (contains? newSet (rightBank aState))
                    (makeState 
                     (set+ newSet (leftBank aState))
                     (set- newSet (rightBank aState)))
                    #f))))))
    
    ; the evaluation function wnats to encourage migration
    ; to the right bank, it therefore subtracts the number
    ; of people on the left bank from the number on  the
    ; right bank
    
    (define evalFN
      (lambda (aState)
        (- (length (set- '(b) (rightBank aState)))
           (length (set- '(b) (leftBank aState))))))
        
    ; set up the Search Problem
    
    (set! MC-SearchProblem
          (MakeSearchProblem initialState
                             goalFN
                             evalFN
                             (MakeActionList
                              (moveSet '(c))
                              (moveSet '(m))
                              (moveSet '(c c))
                              (moveSet '(c m))
                              (moveSet '(m m)))))
    (SetPrintState! MC-SearchProblem printWorld)
    (SetSameState! MC-SearchProblem sameWorld?)))

(begin (SetUpMC)
       #t)
