; Bestiary Example - section 3.5.3
; ======== =======

; This example illustrates the use of the Associative Network
; toolbox to answer questions about animals. Simple statements and
; questions about animals are recognized using the pattern matching
; toolbox and a associative network maintained and queried.
; The sentence forms below show essential parts of the patterns in
; upper case and variables preceeded by a ?
; The form that statements about animals can take are:
;     (an ?invertebrate IS an ?aninmal)
;     (any real ?dog ?eats ?meat)
; The form of questions that can be answered are of the form:
;     (tell me all YOU KNOW)
;     (WHAT IS an ?animal)
;     (WHAT does AN ?animal ?like)
;     (IS an ?invertibrate an ?animal)

; A few initially known facts about beasts

(define Bestiary (MakeAN (CONCEPT 'Creature)
			 (CONCEPT 'Human (AKO 'Creature))
			 (CONCEPT 'Beast (AKO 'Creature))
			 (CONCEPT 'Stuff )))

; facts in the knowledge base are lists of the form
;       (pattern-to-match procedure-to-invoke)

(define MakeFact
  (lambda (aPattern aProcedure) (list aPattern aProcedure)))

(define GetPattern car)
(define GetProc    cadr)

(define QueryPatternsKB
  ; NOTE: Uses the global "Bestiary" for assertions and deductions !!!
  ;the order in which the patterns are tried IS important ! 
  (MakeKB
   
   ; #1: show the state of the network
   (MakeFact (PATTERN ?+ 'you 'know)
             (lambda (aDummy) (PrintAN Bestiary))) 
   
   ; #2: accept questions of the form: (what is an X) 
   (MakeFact 
    (PATTERN 'What 'is (? 'xArticle) (? 'x))
    (lambda (anAL)
      (let ((superClass
             ; get and list all of x's superclasses 
             (GetAKOChain Bestiary   
                          (GetAssociationValue 'x anAL))))
        (if superClass
            (begin
             (DisplayLine 			
              (GetAssociationValue 'xArticle anAL) 
              (GetAssociationValue 'x anAL))
             (for-each 
              (lambda (super) 
                (DisplayLine " is a subclass of " super))
              superClass))
            (display "I don't know - you tell me")))))
   
   ; #3: accept questions of the form: (what does an X Y) 
   (MakeFact 
    (PATTERN 'What ? (? 'xArticle) (? 'x) (? 'y))
    (lambda (anAL)
      (let ((linkedConcepts
             ; get and list all concepts linked to x under label y 
             (FindAllLinkedConcepts 
              Bestiary
              (GetAssociationValue 'x anAL)
              (GetAssociationValue 'y anAL)))
            (getConceptNameOfLink cadr))
        (if linkedConcepts
            (DisplayList 
             (GetAssociationValue 'xArticle anAL)
             (GetAssociationValue 'x anAL)
             (GetAssociationValue 'y anAL)
             (map (lambda (aLink)
                    (getConceptNameOfLink aLink))
                  linkedConcepts))
            (display "I wouldn't have a clue")))))
   
   ; #4: accept questions of the form: (Is an X a Y)
   (MakeFact 
    (PATTERN 'Is (? 'xArticle) (? 'x) (? 'yArticle) (? 'y))
    (lambda (anAL)
      (let ((subclass (GetAssociationValue 'x anAL))
            (superClass (GetAssociationValue 'y anAL)))
        (if (member superClass
		    ; test whether y is on z's ako chain
		    (GetAKOChain Bestiary subclass))
            (display "Yes it is")
            (display "No it is not"))))) 
   
   ; #5: accept assertions of the form: (.. X is .. Y)
   (MakeFact 
    (PATTERN ?+ (? 'x) 'is ?+ (? 'y))
    (lambda (anAL)
      (let ((subclass (GetAssociationValue 'x anAL))
            (superClass (GetAssociationValue 'y anAL)))
        (display "ok")
        (set! Bestiary
              ; make a new concept x and make it ako y
              (AddConcept Bestiary
			  (CONCEPT subclass
				   (AKO superClass)))))))
   
   ; #6: accept assertions of the form: (all .. X Y Z)
   (MakeFact 
    (PATTERN ?+ (? 'x) (? 'y) (? 'z))
    (lambda (anAL)
      (let ((firstConcept (GetAssociationValue 'x anAL))
            (linkSymbol (GetAssociationValue 'y anAL))
            (secondConcept (GetAssociationValue 'z anAL)))
        (if (and (FindConcept Bestiary firstConcept)
		 (FindConcept Bestiary secondConcept))
            (begin
             (display "if you say so.")
             (set! Bestiary
                   ; establish a new link labeled y between 	
                   ; x and z (replace it if it already exists)
                   (AddLink Bestiary
                            firstConcept
                            (LINK linkSymbol 					
                                  secondConcept))))
            (DisplayList "Invalid request ->" 
			 "you haven't defined one of them")
            ))))))

(define Dialogue
  ; NOTE: "fiddles" the global "QueryPatternsKB" !!!  
  (lambda ()
    (DisplayLine "Please supply your input as a list"
		 "(use (bye) to terminate)")
    (display " >> ")
    (do ((sentence (read))
         (aRE #f))
        ((equal? sentence '(bye)) #f)
        (newline)
        ; (aRE -> a RetrievedElement) stores the retrieved list 
        ; returned from the matching process 
        (set! aRE (RetrieveByString QueryPatternsKB
				    sentence
				    GetPattern))
        (if (not aRE)
            (display "Sentence not understood")                   
            (let ((fact (GetFact  aRE))
                  (anAL (GetAList aRE)))
              ; now invoke the relevant procedure on the bindings we
              ; made in matching this query
              ((GetProc fact) anAL)))
        (newline)
        (display " >> ")
        (set! sentence (read)))))

(DisplayLine "Type (Dialogue) to converse about animals")
