; (load "utilities.scm")
; (load "data-collectors.scm")
; (load "distributions.scm")
; (load "de-simulator.scm")
; (load "QN-modules.scm")

; ========== make a Monitor to watch over the gallery==========

(makeinstance (TheGallery Monitor))

; ===== a few Distributions modelling delays and decisions =====

(makeInstance (InterArrivalTime NegExpDist) ((name "arrivals")
                                             (rate 2)) )
(TheGallery 'addDistributions! InterArrivalTime)

(makeInstance (Participate? DrawDist) ((name "participate in competition ?")
                                       (%true 0.5)) )
(TheGallery 'addDistributions! Participate?)

(makeInstance (AdmirePainting UniformDist) ((name "admire painting")
                                           (lower 0.5)
                                           (upper 2.0)) )
(TheGallery 'addDistributions! AdmirePainting)

(makeInstance (AppreciateSculpture ConstantDist) ((name "appreciate sculpture")
                                                  (value (/ 20 60))) ) ; 20 seconds
(TheGallery 'addDistributions! AppreciateSculpture)

(makeInstance (CompositionTime UniformDist) ((name "compose a sonnet")
                                             (lower 0.5)
                                             (upper 1.0)) )
(TheGallery 'addDistributions! CompositionTime)

; ===== a few Resources =====

(makeInstance (Painting Server) ((monitor TheGallery)
                                 (capacity 3)
                                 (q       (FifoQueue 'new)) ) )

(makeInstance (Sculpture Server) ((monitor TheGallery)
                                 (capacity 1)
                                 (q        (FifoQueue 'new)) ) )

; ===== one class of "active" Transactions (with 2 coroutine methods) =====

(defFlavour ArtLover (ako Transaction) (ivars pouch finished?) 
  getivars setivars testivars)

(defCoroutine (artAppreciation ArtLover) ()
  (display ".")   ; give some visual feedback on arrivals
  (if (Participate? 'sample) ; spawn a composition "activity"
      (begin (display "!")
             (monitor 'schedule! self 'composition (monitor 'clockTime)))
      (display " "))
  (Painting 'acquire! self 1) ; queue to sneak a glimpse of the painting
  (self 'hold 'artAppreciation (AdmirePainting 'sample))
  (Painting 'release! self 1) 
  (Sculpture 'acquire! self 1) ; then try to marvel at the sculpture
  (self 'hold 'artAppreciation (AppreciateSculpture 'sample)) 
  (Sculpture 'release! self 1)
  (self 'finished?! #t))

(defCoroutine (composition ArtLover) ()
  (while (not (self 'finished?)) 
         (self 'hold 'composition (CompositionTime 'sample))
         ((self 'pouch) 'update! 1))
  (GalleryDepartures 'depart! self))
         
; ===== and a Source and a Sink for art lovers =====

(makeInstance (GalleryArrivals Source) ((monitor        TheGallery)
                                        (processFlavour ArtLover)
                                        (processParams  '((pouch (Count 'new))
                                                          (finished? #f)) )
                                        (methodName     'artAppreciation)
                                        (arrivalDist    InterArrivalTime)) )

(defFlavour GallerySink (ako Sink) (ivars sonnetBox) testivars)

(defMethod (depart! GallerySink) (anArtLover)
  (sonnetBox 'update! ((anArtLover 'pouch) 'counter))
  (self 'sendToSuperFlavours '(depart! Sink) anArtLover))

(defMethod (show GallerySink) () 
  (displayLine "time spent in gallery (average):") 
  (self 'sendToSuperFlavours '(show Sink))
  (displayLine "=== number of sonnets submitted (total): ===")
  (if (self 'sonnetBox?)
      (sonnetBox 'show)
      (displayLine "NO sonnets submitted !") ))

(makeInstance (GalleryDepartures GallerySink) ((monitor   TheGallery)
                                               (sonnetBox (Count 'new))) )


;;; oooooOOOOOooooo now run a Simulation oooooOOOOOooooo

(TheGallery 'simulate! 30)
(GalleryArrivals 'startUp! 30)
(TheGallery 'startUp!)

(TheGallery 'report)

(GalleryArrivals 'show)
(GalleryDepartures 'show)
(Painting   'show) 
(Sculpture  'show)

