; ***** Implementation of (completely parenthesized) "EXPRESSION"
; these flavours serve as "anchors" for relevant operations - the
; expressions themselves are kept as lists !!! 

(defFlavour Expression (ako Vanilla))

(defMethod (prefix?  Expression) (anExp) 
   (if (member (car anExp) (list '+ '- '* '/ '**))  #t  #f))
(defMethod (infix?   Expression) (anExp)
   (if (member (cadr (anExp)) (list '+ '- '* '/ '**))  #t  #f))
(defMethod (postfix? Expression) (anExp)
   (if (member (caddr (anExp)) (list '+ '- '* '/ '**)) #t  #f))

(defMethod (constant? Expression) (anExp) 
  (and (atom? anExp) (number? anExp)))

(defMethod (variable? Expression) (anExp) 
  (and (atom? anExp) (symbol? anExp)))

(defMethod (expression? Expression) (anExp) (pair? anExp))

(defMethod (binary? Expression) (anExp) 
  (if (self 'expression? anExp)
      (=? (length anExp) 3)
      #f) )

(defMethod (unary? Expression) (anExp) 
  (if (self 'expression? anExp)
      (=? (length anExp) 2)
       #f) )

(defMethod (flat? Expression) (anExp)
; returns #t if an expression's "form" is not nested 
  (define result #t)
  (cond ((atom? anExp) #t)
        ((null? anExp) #t)
        (else (set! result (atom? (CAR anExp)))
              (If result (self 'flat? (CDR anExp)))) ))

(defMethod (show Expression) (anExp)
  (display "the form of this ")
  (cond ((self 'unary?   anExp) (display "unary "))
        ((self 'prefix?  anExp) (display "prefix "))
        ((self 'infix?   anExp) (display "infix  "))
        ((self 'postfix? anExp) (display "postfix "))
        (else (display "IMPROPER ")))
  (display "expression is: ") (newline)
  (display anExp) (newline))

; ----- Unary Expressions -----

(defFlavour UnaryExp (ako Expression))

; ----- Binary Prefix Expressions ---     
  
(defFlavour PrefixExp (ako Expression))

(defMethod (operator  PrefixExp) (anExp) 
  (if (self 'expression? anExp) (car   anExp)))
(defMethod (firstArg  PrefixExp) (anExp) 
  (if (self 'expression? anExp) (cadr  anExp)))
(defMethod (secondArg PrefixExp) (anExp) 
  (if (self 'binary? anExp) (caddr anExp)))

(defMethod (toInfix PrefixExp) (aPrefixExp)
  ;converts an infix expression to a prefix expression 
  (Cond ((Null? aPrefixExp) nil)
        ((Atom? aPrefixExp) aPrefixExp)
        ((self 'unary? aPrefixExp) 
         (list (self 'operator aPrefixExp)
               (self 'toInfix (self 'firstArg aPrefixExp))))
        ((self 'flat? aPrefixExp)  
         (list (self 'firstArg  aPrefixExp)
               (self 'operator  aPrefixExp)
               (self 'secondArg aPrefixExp)))
        (else  (list (self 'toInfix (self 'firstArg  aPrefixExp))
                     (self 'operator aPrefixExp)
                     (self 'toInfix (self 'secondArg aPrefixExp)))) 
        ))

(defMethod (derive PrefixExp) (anExp aVar)                           
; differentiates an expression with respect to a given variable. 
; The expression must be in fully parenthesized prefix notation.
; An infix expression is returned as a result.
; *** NOTE: Only the following BINARY operators are recognized: +, -, *, /, **
  
  (define dummy (Expression 'new))    
  (define (sameVar? x y) (eq? x y))
  
 (define (makeSum arg1 arg2)
  (Cond ((And (Number? arg1) (Number? arg2)) (+ arg1 arg2))
        ((Number? arg1) (If (Zero? arg1) arg2 (list '+ arg1 arg2)))
        ((Number? arg2) (If (Zero? arg2) arg1 (list '+ arg1 arg2)))
        (else (list '+ arg1 arg2))) )

(define (sum? anExp)
  (and (self 'expression? anExp) (eq? (self 'operator anExp) '+))) 

(define (makeDifference arg1 arg2)
  (Cond ((And (Number? arg1) (Number? arg2)) (- arg1 arg2))
        ((Number? arg1) (If (Zero? arg1)
                            (begin (if (Atom? arg2)
                                       (begin 
                                        (string->symbol 
                                         (string-append 
                                          (symbol->string '-)
                                          (if (number? arg2) 
                                              (number->string arg2) 
                                              (symbol->string arg2)))))
                                       (list '- arg2)))
                            (list '- arg1 arg2)))
        ((Number? arg2) (If (Zero? arg2) arg1 (list '- arg1 arg2)))
        (else (list '- arg1 arg2))) )

(define (difference? anExp)
  (and (self 'expression? anExp) (eq? (self 'operator anExp) '-))) 

(define (makeProduct arg1 arg2)
  (Cond ((And (Number? arg1) (Number? arg2)) (* arg1 arg2))
        ((Number? arg1) (Cond ((Zero? arg1) 0)
                              ((=?  1 arg1) arg2)
                              ((=? -1 arg1) (list '- arg2))
                              (else         (list '* arg1 arg2))) )
        ((Number? arg2) (Cond ((Zero? arg2) 0) 
                              ((=?  1 arg2) arg1)
                              ((=? -1 arg2) (list '- arg1))
                              (else         (list '* arg1 arg2))) )
        (else (list '* arg1 arg2)) ))

(define (product? anExp)
  (and (self 'expression? anExp) (eq? (self 'operator anExp) '*))) 

(define (makeQuotient arg1 arg2)
  (Cond ((And (Number? arg1) (Number? arg2)) (/ arg1 arg2))       
        ((Number? arg1) (If (Zero? arg1)  0  (list '/ arg1 arg2)))
        ((Number? arg2) 
         (Cond ((Zero? arg2)
                (display "Division by zero !!!") (newline) (reset))
               ((=?  1 arg2) arg1)
               (else (list '/ arg1 arg2))))
        (else (list '/ arg1 arg2)) ))

(define (quotient? anExp)
  (and (self 'expression? anExp) (eq? (self 'operator anExp) '/))) 

(define (makePower aBase anExp)
  (Cond ((And (Number? aBase) (Number? anExponent)) 
         (expt aBase anExp))       
        ((Number? aBase) (Cond ((Zero? aBase) 0)
                               ((=?  1 aBase) 1)  
                               (else (list '** aBase anExp))))
        ((Number? anExp) (Cond ((Zero? anExp) 1)
                              ((=?   1 anExp) aBase)
                              (else (list '** aBase anExp))))
        (else (list '** aBase anExp)) ))

(define (power? anExp)
  (and (self 'expression? anExp) (eq? (self 'operator anExp) '**))) 
  
  (cond  ; expression is a constant or variable 
         ; - return 1 if same as "aVar, 0 otherwise
     ((self 'constant? anExp) 0)
     ((self 'variable? anExp) (If (SameVar? anExp aVar) 1  0))
         ; expression is not in prefix form - reject !
     ((not (dummy 'prefix? anExp))  
      (display "NOT a prefix exp - rejected") nil)      
         ; expression is a sum or difference - add or subtract their differentials
     ((sum? anExp) 
      (makeSum (self 'derive (self 'firstArg  anExp) aVar)
               (self 'derive (self 'secondArg anExp) aVar)) ) 
     ((difference? anExp) 
      (makeDifference (self 'derive (self 'firstArg  anExp) aVar)
                      (self 'derive (self 'secondArg anExp) aVar)) )
        ; expression is a Product - multiply partners' differentials and add
     ((product? anExp) 
      (makeSum (makeProduct (self 'firstArg anExp)
                            (self 'derive (self 'secondArg anExp) aVar))
               (makeProduct (self 'secondArg anExp)
                            (self 'derive (self 'firstArg  anExp) aVar))) )        
        ; expression is a Quotient - differentiate product of first and (1 over second arg)
     ((quotient? anExp) 
      (self 'derive (makeProduct (self 'firstArg anExp)
                                 (makePower (self 'secondArg anExp) -1))
                    aVar))
        ; expression is a Power - differentiate product of exponent 
        ; and (one less than original exponentiation)
     ((power? anExp) 
      (makeProduct (self 'secondArg anExp)
                   (makeProduct 
                     (makePower (self 'firstArg anExp)
                                (makeDifference (self 'secondArg anExp) 1))
                     (self 'derive (self 'firstArg anExp) aVar)))) )) 


; ----- Binary Infix Expressions ----- 

(defFlavour InfixExp (ako Expression))

(defMethod (operator  InfixExp) (anExp) 
  (if (self 'binary? anExp) (cadr anExp)))
(defMethod (firstArg  InfixExp) (anExp) 
  (if (self 'binary? anExp) (car  anExp)))
(defMethod (secondArg InfixExp) 
  (anExp) (if (self 'binary? anExp) (caddr anExp)))

(defMethod (toPrefix InfixExp) (anInfixExp)
  ;converts a prefix expression to an infix expression 
  (Cond ((Null? anInfixExp) nil)
        ((Atom? anInfixExp) anInfixExp)
        ((self 'unary? anInfixExp) (list (self 'operator anInfixExp)
                                         (self 'toPrefix 
                                               (self 'firstArg anInfixExp))))
        ((self 'flat? anInfixExp)  (list (self 'operator  anInfixExp)
                                         (self 'firstArg  anInfixExp)
                                         (self 'secondArg anInfixExp)))
        (else  (list (self 'operator anInfixExp)
                     (self 'toPrefix (self 'firstArg  anInfixExp))
                     (self 'toPrefix (self 'secondArg anInfixExp)))) ))

(defMethod (derive InfixExp) (anInfixExp aVar)
  (define dummy (PrefixExp 'new))  
  (dummy 'toInfix (dummy 'derive (self 'toPrefix anInfixExp) aVar)) )
  

; ----- Binary Postfix Expressions -----

; NOT YET IMPLEMENTED
                                
 
  