; Call with environment.
; Written October 1987 by M.C. Stairmand and G.C. Ewing.


; Mark 1 now discontinued
;(define call-with-environment
;  (lambda (e f . args)
;    (let ((olde (get-environment f)) (r '*))
;      (set-environment! f e)
;      (set! r (apply f args))
;      (set-environment! f olde)
;      r)))
;(define get-environment
;  (lambda (f)
;    (cdr (->pair f))))
;
;(define set-environment!
;  (lambda (f e)
;    (set-cdr! (->pair f) e)))

; Mark 2 implementation dependant and a bit hairy but fast and efficient.
; This is the hard bit.
; The local "newf" is assigned a closure. This closure is made up
; of the car of the function to be called, (the code pointer)
; and the new environment (the environment pointer).
; ->pair is needed because although a closure is a pair, it does not
; look like one. Similarly, ->procedure is used to turn a "pair" back
; into a closure.
(define call-with-environment
  (lambda (e f . args)
    (set! args (car args))
    (let ((newf (->procedure (cons (car (->pair f)) e))))
      (apply newf args))))

(define call/we call-with-environment)

(define call/cc call-with-current-continuation)

