; M.C. Stairmand Nov. 1987

; Instance and environment creators.

; create an instance, giving environment and meths.

(define instantiate
  (lambda (env meths **name**)
    (eval `(set! ,**name**
    (lambda (mess . args)
        (if trace
            (begin
             (disp **name** " has been sent the message: " mess)
             (newline)))
        (if (findmethod mess (car meths))
            (call/we env (findmethod mess (car meths)) args)
            (if (eq? '**env** mess)
                env
                (if (eq? 'trace! mess)
                    (set! trace (car args))
                    (if (eq? 'trace mess)
                        trace
                        (begin
                         (cerror "Sorry, but I don't know how to " mess args)
                         )))))))
          (let ((trace #f))
      (make-environment)))))
  
; create an environment

(define make-environment-maker
  (lambda (ivars)
    (eval `(lambda () (let ,ivars (make-environment))))))

(define m-e-m make-environment-maker)

; make a method

(define makemethod
  (lambda (env code)
    (eval `(lambda ,@code) env)))

; make method and add it to a method list

(define method-adder 
  (lambda (sofar name env code)
    (cons (cons name (list (makemethod env code))) sofar)))

(define findmethod
  (lambda (mess meths)
    (cdr (assq mess meths))))
  
(define bootstrap-flavour
  (lambda (ivars meths)
    (let ((envm '*) (env '*) (mlist '*) (flav '*))
      (set! envm (m-e-m ivars))
      (set! env (envm))
      (set! mlist (cons (mapcar (lambda (m)
                                  (cons (car m)
                                        (makemethod env (cdr m))))
                                meths)
                        'GCE))
      (set! flav (instantiate env mlist 'flavour))
      (newline)
      (flav 'mlist! mlist)
      (flav 'env! env)
      (flav 'methods! meths)
      (flav 'ivars! ivars)
      (flav 'name! 'flavour)
      (flav 'envm! envm)
      (flav '**self!** flav)
      (flav '**mum!** 'flavour)
      flav)))

(define bootstrap-vanilla
  (lambda (ivars meths)
    (let ((envm '*) (env '*) (mlist '*) (flav '*))
      (set! envm (m-e-m ivars))
      (set! env (envm))
      (set! mlist (cons (mapcar (lambda (m)
                                  (cons (car m)
                                        (makemethod env (cdr m))))
                                meths)
                        'GCE))
      (set! flav (instantiate env mlist 'vanilla))
      (newline)
      flav)))