
object generator.

   % This object provides generators. Sofar, only integer generators
   % are implemented.

   :- publish int/1,       % int(I) returns numbers I from 0 on backtracking
              int/2,       % int(First,I) returns numbers I from First
              int/3,       % int(First,Step,I) returns numbers I from First by Step
              int/4,       % int(First,Step,Last,I) returns numbers I from First to
                           % Last by Step (Step may be negative)
              int_list/3,  % int_list(First,Last,L) returns a list L with
                           % numbers from First to Last
              int_list/4.  % int_list(First,Step,Last,L) returns a list L with
                           % numbers from First to Last in Step intervals

   int(I) :- this::int1(0, 1, I).

   int(F, I) :- this::int1(F, 1, I).

   int(F, S, I) :- this::int1(F, S, I).

   int1(I, _, I).
   int1(N, S, I) :- N1 is N+S, !, this::int1(N1, S, I).

   int(I, _, _, I).
   int(N, S, L, I) :- S > 0, N1 is N+S, N1 =< L, !, this::int(N1, S, L, I).
   int(N, S, L, I) :- S < 0, N1 is N+S, N1 >= L, !, this::int(N1, S, L, I).

   int_list(I, I, [I]).
   int_list(I, L, [I|IL]) :- I < L, I1 is I+1, !, this::int_list(I1, L, IL).
   int_list(F, L, [])     :- F > L.

   int_list(I, _, I, [I]).
   int_list(I, S, L, [I|IL]) :- S > 0, I < L, I1 is I+S, !, this::int_list(I1, S, L, IL).
   int_list(I, S, L, [I|IL]) :- S < 0, I > L, I1 is I+S, !, this::int_list(I1, S, L, IL).
   int_list(F, S, L, [])     :- S > 0, F > L.
   int_list(F, S, L, [])     :- S < 0, F < L.

end_object generator.
