/*
 * state.h
 * Header file for state.c
 *
 * AUTHOR:  David Roch
 *
 * CONTRIBUTORS:
 *	DAR - David Roch
 *
 * HISTORY:
 *	7/13/88 - Created DAR
 */

#ifndef	H_STATE		/* if this file has not already been included */
#define H_STATE	1	/* indicate this file has been included */

#define DOES_NOT_EXIST	-1

/* STATE of a variable */
typedef struct STATE {
  SLOT	var;	/* variable identifier */
  SHORT type,	/* member of type system */
  	alias;	/* aliasing information */
  char	flags;	/* flags asociated with type */
} STATE;

/*
 * state flags
 * use macros SET_FLAG(var, flag) & IN_FLAG(var, flag) from
 * pgm_typedefs.h to access flags field
 */

#define	ACCESSED	0	/* determine if variable accessed */
#define MODIFIED	1	/* variable may have been modified? */

/* STATETBL table of states */
typedef struct STATETBL {
  SHORT	vars;	/* number of variables allocated so far */
  STATE *st;	/* Pointer to array of states - will always
		 * be statically allocated to # of vars in clause
		 */
} STATETBL;

#endif








