/* definition of the FAIL macro for failed unification : results in 
   backtracking during sequential execution */

#define MAXSTACKSIZE 15000
#define MAXTRAILSIZE 5000

#define SEQ_MOLECULE_ADDRESS(term)  (MOLECULE_PTR *) &term[INDEX(term)]

#define COPY_SEQ_MOLECULE(term1, term2)  INSERT_INDEX(term1, &term2[INDEX(term2)] - term1, SEQ_MOLECULE)


#define TAG_IS_SEQ_MOLECULE(slot)\
	COMPARE_LONG_TAG(slot, SEQ_MOLECULE)

#define FAIL()  \
{\
    for(; TR > VV->TR; TR--)\
        INSERT_SLOT_TAG(*(TR-1), UNBOUND_VAR);\
    FL = VV->FL;\
    while (FL < 0)\
    {\
        TOS = (LONG *) VV;\
	VV = VV->PrevChoicePt;\
	if (VV == NULL)\
	    break;\
	for(; TR > VV->TR; TR--)\
            INSERT_SLOT_TAG(*(TR-1), UNBOUND_VAR);\
	FL = VV->FL;\
    }\
    if (VV == NULL)\
	suspend = TRUE;\
    else \
    {\
        V = VV;\
	PTerm = VV->PTerm;\
	PTuple = VV->PTuple;\
	PC = FL;\
    }\
}

