#include "typedefs.h"
#include "macros.c"
#include "be_macros.c"

extern SHORT CONS;
extern SHORT NILATOMINDEX;


void ParPrintTerm(term, tuple, strin)
SLOT *term;
SLOT *tuple;
char 	 strin[];

{ 
    SHORT 	 i;
    SHORT 	 arity, tindex;
    SHORT 	 *PgmLookupAtom();
    MOLECULE_PTR *molecule;
    SLOT	 *address;
    SLOT 	 *tempterm;
    BOOLEAN      done;
    char 	 strout[1000];

    strout[0] = '\0';

    switch (SLOT_TAG(term))
    { 
    case ABSOLUTE_ADDRESS: 
		ParPrintTerm(ABS_ADDRESS(term), tuple, strout);
		break;
    case MOLECULE:
		molecule = MOLECULE_ADDRESS(term);
		ParPrintTerm(TERMS(molecule), TUPLE(molecule), strout);
		break;

    case FUNCTOR:
    case CLOSED_TERM:
 		if (GET_FUNCTOR(term) == CONS)
		{
		    done = FALSE;
		    strcat(strout,"[");
		    while (!done)
		    {
			tempterm = term + 1;
			Deref_Term(tempterm, tuple);
			ParPrintTerm(tempterm, tuple, strout);
			term += 2;
			Deref_Term(term, tuple);
			if (TAG_IS_MOLECULE(term))
			{
			    molecule = MOLECULE_ADDRESS(term);
			    term = TERMS(molecule);
			    tuple = TUPLE(molecule);
			}

			if (TAG_IS_FUNCTOR(term))
			{
			    if (GET_FUNCTOR(term) != CONS &&
				GET_FUNCTOR(term) != NILATOMINDEX)
			    {
			        ParPrintTerm(term, tuple, strout);
				strcat(strout,"]");
				done = TRUE;
			    }
			    else if (GET_FUNCTOR(term) == NILATOMINDEX)
			    {
				strcat(strout,"]");
				done = TRUE;
			    }
			    else strcat(strout,",");
			}
			else
			{
			    strcat(strout,",");
			    ParPrintTerm(term, tuple, strout);
			    strcat(strout,"]");
			    done = TRUE;
			}
		    }
		}
		else
		{ 
		    sprintf(strout,"%s", PgmGetAtom(GET_FUNCTOR(term)) );
		    arity = ARITY(term);
		    term++;
		    if (arity > 0)
		    { /*pcount[201]++;*/ 
		      strcat(strout,"(");
		      for (i = 1; i < arity; i++)
		      { /*pcount[202]++;*/ 
			ParPrintTerm(term, tuple, strout);
			term++;
			strcat(strout,",");
		      }
		      ParPrintTerm(term, tuple, strout);
		      strcat(strout,")");
		    }
		}  
		    break;
    case TUPLE_INDEX_1:
		tindex = INDEX(term);
		if (tindex <= TUPLESIZE(tuple)) 
		     ParPrintTerm( &(tuple[tindex]), tuple, strout);
		else OsPrint("ParPrintTerm: error! tuple index %d out of range\n",tindex);  
		break;
    case TUPLE_INDEX_2:
		OsPrint("ParPrintTerm: error! illegal slot_tag -TUPLE_INDEX_2\n");
		break;
    case RELATIVE_INDEX:
		ParPrintTerm(term + INDEX(term), tuple, strout);
		break;
    case TERM_SPC_INDEX_1:
		ParPrintTerm( &(term_space[INDEX(term)]),tuple, strout);
		break;
    case TERM_SPC_INDEX_2:
		OsPrint("ParPrintTerm: error! illegal slot_tag -TERM_SPC_INDEX_2\n");
		break;
    case INTEGER:	   
		sprintf(strout,"%d",INTVALUE(term));
		break;
    case REAL:
		sprintf(strout,"%f", REALVALUE(term));
		break;
    case UNBOUND_VAR:	   
		sprintf(strout,"_%x",(LONG)term);
		break;
    case BLOCKED_VAR:
		strcat(strout,"*");
		break;
    case TUPLE_SIZE:	   
		OsPrint("ParPrintTerm: error! illegal slot_tag - TUPLE_SIZE\n");
		break;
    default:	
		OsPrint("ParPrintTerm: unknown slot_tag %d\n",SLOT_TAG(term));
    } /* switch */
    strcat(strin, strout);
}


void PrintTerm(term, tuple)
SLOT *term;
SLOT *tuple;

{ 
    SHORT 	 i;
    SHORT 	 arity, tindex;
    SHORT 	 *PgmLookupAtom();
    MOLECULE_PTR *molecule;
    SLOT	 *address;
    SLOT 	 *tempterm;
    BOOLEAN      done;

/*pcount[199]++;*/ 
    switch (SLOT_TAG(term))
    { 
    case ABSOLUTE_ADDRESS: 
		PrintTerm(ABS_ADDRESS(term), tuple);
		break;
    case MOLECULE:
		molecule = MOLECULE_ADDRESS(term);
		PrintTerm(TERMS(molecule), TUPLE(molecule));
		break;

    case FUNCTOR:
    case CLOSED_TERM:
 		if (GET_FUNCTOR(term) == CONS)
		{
		    done = FALSE;
		    OsPrint("[");
		    while (!done)
		    {
			tempterm = term + 1;
			Deref_Term(tempterm, tuple);
			PrintTerm(tempterm, tuple);
			term += 2;
			Deref_Term(term, tuple);
			if (TAG_IS_MOLECULE(term))
			{
			    molecule = MOLECULE_ADDRESS(term);
			    term = TERMS(molecule);
			    tuple = TUPLE(molecule);
			}

			if (TAG_IS_FUNCTOR(term))
			{
			    if (GET_FUNCTOR(term) != CONS &&
				GET_FUNCTOR(term) != NILATOMINDEX)
			    {
			        PrintTerm(term, tuple);
				OsPrint("]");
				done = TRUE;
			    }
			    else if (GET_FUNCTOR(term) == NILATOMINDEX)
			    {
				OsPrint("]");
				done = TRUE;
			    }
			    else OsPrint(",");
			}
			else
			{
			    OsPrint(",");
			    PrintTerm(term, tuple);
			    OsPrint("]");
			    done = TRUE;
			}
		    }
		}
		else
		{ 
		    OsPrintf("%s", PgmGetAtom(GET_FUNCTOR(term)));
		    arity = ARITY(term);
		    term++;
		    if (arity > 0)
		    { /*pcount[201]++;*/ 
		      OsPrint("(");
		      for (i = 1; i < arity; i++)
		      { /*pcount[202]++;*/ 
			PrintTerm(term, tuple);
			term++;
			OsPrint(",");
		      }
		      PrintTerm(term, tuple);
		      OsPrint(")");
		    }
		}  
		    break;
    case TUPLE_INDEX_1:
		tindex = INDEX(term);
		if (tindex <= TUPLESIZE(tuple)) 
		     PrintTerm( &(tuple[tindex]), tuple);
		else OsPrint("PrintTerm: error! tuple index %d out of range\n",tindex);  
		break;
    case TUPLE_INDEX_2:
		OsPrint("PrintTerm: error! illegal slot_tag -TUPLE_INDEX_2\n");
		break;
    case RELATIVE_INDEX:
		PrintTerm(term + INDEX(term), tuple);
		break;
    case TERM_SPC_INDEX_1:
		PrintTerm( &(term_space[INDEX(term)]),tuple);
		break;
    case TERM_SPC_INDEX_2:
		OsPrint("PrintTerm: error! illegal slot_tag -TERM_SPC_INDEX_2\n");
		break;
    case INTEGER:	   
		OsPrint("%d",INTVALUE(term));
		break;
    case REAL:
		OsPrint("%f", REALVALUE(term));
		break;
    case UNBOUND_VAR:	   
		OsPrint("_%ld",(LONG)term);
		break;
    case BLOCKED_VAR:
		OsPrint("*");
		break;
    case TUPLE_SIZE:	   
		OsPrint("PrintTerm: error! illegal slot_tag - TUPLE_SIZE\n");
		break;
    default:	
		OsPrint("PrintTerm: unknown slot_tag %d\n",SLOT_TAG(term));
    } /* switch */
}



void BePrintGoal(goal)
GOAL *goal;

{ 
    void PrintTerm();
 
/*pcount[203]++;*/ 
    OsPrint("GOAL:	");
    PrintTerm(TERMS(goal), TUPLE(goal));
    OsPrint("\n");
}




void BePrintTuple(tuple)
SLOT *tuple;

{
    SHORT i;

 /*pcount[204]++;*/ 
    for (i = 1; i < TUPLESIZE(tuple); i++)
    { /*pcount[205]++;*/ 
	OsPrint("$%d	=	",i);
	PrintTerm( &(tuple[i]), tuple);
	OsPrint("\n");
    }
}



void BePrintResponse(response)
RESPONSE *response;

{
    void BePrintTuple();

    /*pcount[206]++;*/ 
    if (response != NULL)
    {
	OsPrint("The response tuple is:\n");
	BePrintTuple(RESP_TUPLE(response));
    }
    else OsPrint("The response tuple is NULL\n");
}


