#include "os_macros.c"

extern SLOT  *term_space;
extern BOOLEAN systemDone;
extern LONG	next_term;
extern LONG 	maxTerm;
extern LONG	PURE_CODE_MARKER;
extern BOOLEAN  DEBUG,DEBUG2;

/* macros to access data structures defined in typedefs.h */

/* SLOT_TAG returns the slot tag of the SLOT pointed at by goal_resp */

/*
 * DEREF(SLOT term)
 * DEREFPTR(SLOT *term)
 * Given a SLOT or pointer to a SLOT, dereferences if the slot
 * (or pointer) contains an address.
 */
#define DEREF(term) \
  if (TAG_IS_ADDRESS((SLOT *) term))	 \
     term = (SLOT) ABS_ADDRESS((SLOT *) term)
#define DEREFPTR(term) \
  if (TAG_IS_ADDRESS(term))	\
     term = ABS_ADDRESS(term)


#define SLOT_TAG(slot)\
	(((SHORT)*slot & 0x03) < 2 ?\
	      ((SHORT)*slot & 0x03) :  ((SHORT)*slot & 0x01F))
 
#define COMPARE_LONG_TAG(slot, tag)\
	(((SHORT)*slot & 0x01F) == tag)

#define COMPARE_SHORT_TAG(slot, tag)\
	(((SHORT)*slot & 0x03) == tag)

#define TAG_IS_ADDRESS(slot)\
	COMPARE_SHORT_TAG(slot, ABSOLUTE_ADDRESS)

#define TAG_IS_MOLECULE(slot)\
	COMPARE_SHORT_TAG(slot, MOLECULE)

#define TAG_IS_FUNCTOR(slot)\
	(COMPARE_LONG_TAG(slot, FUNCTOR) ||\
	COMPARE_LONG_TAG(slot, CLOSED_TERM))

#define TAG_IS_CLOSED_TERM(slot)\
	COMPARE_LONG_TAG(slot, CLOSED_TERM) 

#define TAG_IS_TUPLE_INDEX_1(slot)\
	COMPARE_LONG_TAG(slot, TUPLE_INDEX_1)

#define TAG_IS_TUPLE_INDEX_2(slot)\
	COMPARE_LONG_TAG(slot, TUPLE_INDEX_2)

#define TAG_IS_REL_INDEX(slot)\
	COMPARE_LONG_TAG(slot, RELATIVE_INDEX)

#define TAG_IS_TERM_INDEX_1(slot)\
	COMPARE_LONG_TAG(slot, TERM_SPC_INDEX_1)

#define TAG_IS_TERM_INDEX_2(slot)\
	COMPARE_LONG_TAG(slot, TERM_SPC_INDEX_2)

#define TAG_IS_INTEGER(slot)\
	COMPARE_LONG_TAG(slot, INTEGER)

#define TAG_IS_REAL(slot)\
	COMPARE_LONG_TAG(slot, REAL)

#define TAG_IS_UNBOUND(slot)\
	COMPARE_LONG_TAG(slot, UNBOUND_VAR)

#define TAG_IS_BLOCKED(slot)\
	COMPARE_LONG_TAG(slot, BLOCKED_VAR)

#define TAG_IS_TUPSIZE(slot)\
	COMPARE_LONG_TAG(slot, TUPLE_SIZE)

#define TAG_IS_FREE_SLOT(slot)\
	COMPARE_LONG_TAG(slot, FREE_SLOT)

#define INTVALUE(slot)\
	((LONG)*slot >> SLOT_TAG_SIZE)

#define REALVALUE(slot)\
	(float)(term_space[((LONG)*slot >> SLOT_TAG_SIZE)])

#define ABS_ADDRESS(slot)\
	(SLOT *)*slot

#define MOLECULE_ADDRESS(slot)\
	(MOLECULE_PTR *)(*slot & ~0x01)
	
#define GET_FUNCTOR(slot)\
	((LONG)*slot >> SYM_TAB_SHIFT)

#define ARITY(slot)\
	(((SHORT)*slot >> FUNCTOR_SHIFT) & 0x01F)

#define ARITY_IS_ZERO(slot)\
	(((SHORT)*slot & 0x0F800) == 0)

#define INDEX(slot)\
	((LONG)*slot >> SLOT_TAG_SIZE)

#define TUPLESIZE(slot)\
        (slot == NULL ? 0 : (SHORT)((LONG)*slot >> FUNCTOR_SHIFT) & 0x01FFF)
	/* shift out the slot tag and the ref-count */

/* The following do the assignment of the slot-tag also */

#define INCREMENT_REF_COUNT(slot)\
	McLockMem1();\
        if (slot != NULL && ((SHORT)(*slot & 0x07E0) < 0x07E0)) \
	   *slot += 0x020;\
	McUnlockMem1()

#define SET_REF_COUNT_ONE(slot)\
	McLockMem1();\
        *slot = (*slot & ~0x07E0) + 0x020;\
	McUnlockMem1()

#define DECREMENT_REF_COUNT(slot)\
	McLockMem1();\
        if  (slot != NULL &&((SHORT)(*slot & 0x07E0) < 0x07E0)) \
	   *slot -= 0x020;\
	McUnlockMem1()


#define REF_COUNT_ZERO(slot)\
	((*slot & 0x07E0) == 0)


#define INSERT_ADDRESS(slot, address)\
    *slot = (SLOT)address;\
    INCREMENT_REF_COUNT(address)



#define INSERT_MOLECULE(slot, molecule)\
    *slot =(SLOT)((LONG)molecule | 0x01)


#define COPY_MOLECULE(slot1, slot2, molecule)\
	*slot1 = *slot2;\
	INCREMENT_REF_COUNT(&(molecule->ref_count))



#define  INSERT_INTEGER(slot, val)\
    *slot = (SLOT)((val << SLOT_TAG_SIZE) | 0x0E)


#define COPY_INTEGER(slot1, slot2)\
	*slot1 = *slot2

#define SAME_FUNCTOR_ARITY(slot1, slot2)\
	((*slot1 >> FUNCTOR_SHIFT) == (*slot2 >> FUNCTOR_SHIFT)) 


#define INTEGERS_EQUAL(slot1, slot2)\
	(*slot1 == *slot2)

#define INSERT_REAL(slot, val)\
{ \
    SHORT index;\
\
    Malloc_Real(index);\
    *slot = (SLOT)((index << SLOT_TAG_SIZE) | 0x0F);\
    term_space[index] = (SLOT) (val);\
}

#define REALS_EQUAL(slot1, slot2)\
	(*slot1 == *slot2 || \
	(SLOT_TAG(slot1) == SLOT_TAG(slot2) && \
	 	REALVALUE(slot1) == REALVALUE(slot2)))


#define COPY_REAL(slot1, slot2)\
	*slot1 = *slot2


#define INSERT_FUNCTOR(slot, sym_entry, arity)\
    *slot = (SLOT)((sym_entry << SYM_TAB_SHIFT) |\
		   (arity << FUNCTOR_SHIFT)  | 0x02) 

#define INSERT_CLOSED_TERM(slot, sym_entry, arity)\
    *slot = (SLOT)((sym_entry << SYM_TAB_SHIFT) |\
		   (arity << FUNCTOR_SHIFT)  | 0x017)


#define MAKE_CLOSED_TERM(slot)\
    *slot = (SLOT)((*slot & ~0x01F) | 0x017)

#define MAKE_SLOT_FREE(slot)\
    *slot = (SLOT)((*slot & ~0x01F) | 0x01A)

/* the following macro is used for inserting TUPLE indices, RELATIVE index
   and TERM_SPACE indices */

#define INSERT_INDEX(slot, index, slot_tag)\
    *slot = (SLOT)((index << SLOT_TAG_SIZE) | slot_tag)

#define INSERT_TERM_INDEX(slot, index, slot_tag)\
{\
    *slot = (SLOT)((index << SLOT_TAG_SIZE) | slot_tag);\
    INCREMENT_REF_COUNT(&(term_space[index])); \
}


#define COPY_INDEX(slot1, slot2, new_tag)\
   *slot1 = (SLOT)((*slot2 & ~0x01F) | new_tag)


#define INSERT_SLOT_TAG(slot, slot_tag)\
    *slot = (SLOT)(slot_tag)


#define INSERT_TUPLE_SIZE(slot, size)\
    *slot = (SLOT)((size << FUNCTOR_SHIFT) | 0x016)
/* need to shift SLOT_TAG_SIZE + REF_CNT_SIZE */

#define COPY_SLOT(slot1, slot2)\
{\
	*slot1 = *slot2;\
	if (TAG_IS_MOLECULE(slot2))\
	{\
	     INCREMENT_REF_COUNT(&((MOLECULE_ADDRESS(slot2))->ref_count));\
	}\
	else if (TAG_IS_ADDRESS(slot2))\
	{\
	     INCREMENT_REF_COUNT(ABS_ADDRESS(slot2));\
	}\
}


#define COPY_ATOM(slot1, slot2)\
	*slot1 = *slot2



#define REDUCE(slot1, count, closedterm)\
{\
	SHORT i;\
	SLOT *newslot;\
\
	Malloc_Slots(newslot, count);\
	for (i = 0; i < count; i++)\
		newslot[i] = slot1[i];\
	if (*closedterm) MAKE_CLOSED_TERM(newslot);\
	INSERT_ADDRESS(slot1, newslot);\
}




/************************************************************************/
/*									*/
/*		GOAL, RESP  AND MOLECULE MACROS			*/
/*									*/
/************************************************************************/

#define REF_COUNT(molecule)	&(molecule->ref_count)

#define TERMS(molecule)	molecule->terms

#define TUPLE(molecule)	molecule->tuple

#define INIT_MOLEC_RCNT(molecule)\
	molecule->ref_count = (SLOT) (0x01 << SLOT_TAG_SIZE);\
	INCREMENT_REF_COUNT(TERMS(molecule));\
	INCREMENT_REF_COUNT(TUPLE(molecule))   

#define INSERT_MOLEC_TERMS(molecule,term)\
	molecule->terms = term

#define INSERT_MOLEC_TUPLE(molecule,tuple1)\
	molecule->tuple = tuple1


#define GOAL_TERMS(goal)	goal->terms

#define GOAL_TUPLE(goal)	goal->tuple

#define GOAL_BUILTIN(goal)	goal->builtin_index

#define RESP_TUPLE(resp)	(SLOT *) resp

#define INSERT_GOAL_TERMS(goal, term1)\
	goal->terms = term1

#define INSERT_GOAL_TUPLE(goal, tuple1)\
	goal->tuple = tuple1

#define INSERT_GOAL_BUILTIN(goal, index)\
	goal->builtin_index = index

#define INSERT_RESP_TUPLE(resp, tuple1)\
	resp = (RESPONSE *) tuple1


/* returns a pointer to a slot */
#define BePredicateName(goal)\
	goal->terms

/************************************************************************/
/*									*/
/*			MESSAGE MACROS					*/
/*									*/
/************************************************************************/

/* argument is a pointer to MESSAGE */
#define MSGTYPE(msg)\
	(msg->msgType)

#define MSGMAINTYPE(msg)\
	(msg->msgType & 0x7)

#define MSGSUBTYPE(msg)\
	(msg->msgType & 0x38)

#define MSGOSBK(message)\
	(message ->srcOsBlock)

#define MSGPENUM(message)\
	(message->srcPeNum)

#define MSGTASKID(message)\
	(message->srcTaskNum)

#define MSGGSLOT(message)\
	(message->goalSlot)

#define MSGGOAL(message)\
	(message->goalResp.goal)

#define MSGRESP(message)\
	(message->goalResp.response)

#define MSGCNUM(message)\
	(message->cNum)

#define MSGRNUM(message)\
	(message->rNum)

#define INSERT_MSGPENUM(message, peNum1)\
	message->srcPeNum = peNum1

#define INSERT_MSGTYPE(message, msgtype1)\
	message->msgType = msgtype1

#define INSERT_MSGGSLOT(message, goalslot1)\
	message->goalSlot = goalslot1

#define INSERT_MSGOSBK(message, osBk)\
	message->srcOsBlock = osBk

#define INSERT_MSGTASKID(message, t)\
	message->srcTaskNum = t

#define INSERT_MSGGOAL(message, goal1)\
	message->goalResp.goal = goal1

#define INSERT_MSGRESP(message, response1)\
	message->goalResp.response = response1
	
#define INSERT_MSGCNUM(message, cnum1)\
	message->cNum = cnum1

#define INSERT_MSGRNUM(message, rnum1)\
	message->rNum = rnum1

#define ADD_RESP_CNUM(msg,count)\
	{ /*pcount[98]++;*/ msg->msgType |= MSGTYPE_RESPCNUM;\
	msg->cNum = count;}

#define ADD_RESP_RNUM(msg,count)\
	{ /*pcount[99]++;*/ msg->msgType |= MSGTYPE_RESPRNUM;\
	msg->rNum = count;}


#define IS_RESP_CNUM(msg)\
	(MSGSUBTYPE(msg) & MSGTYPE_RESPCNUM)

#define IS_RESP_RNUM(msg)\
	(MSGSUBTYPE(msg) & MSGTYPE_RESPRNUM)

#define IS_RESP_DATA(msg)\
	(MSGSUBTYPE(msg) & MSGTYPE_RESPDATA)

#define NEWMSGGOAL(ptr,type,pe,os,t,gs,gr,r,c)\
    	{ /*pcount[101]++;*/ /*palloc(MESSAGE,1,ptr);*/\
    	Malloc_Message(ptr);\
    	INSERT_MSGTYPE(ptr, type);\
    	INSERT_MSGPENUM(ptr, pe);\
	INSERT_MSGOSBK(ptr, os);\
	INSERT_MSGTASKID(ptr, t);\
    	INSERT_MSGGSLOT(ptr, gs);\
	INSERT_MSGGOAL(ptr, gr);\
	INSERT_MSGRNUM(ptr, r);\
	INSERT_MSGCNUM(ptr, c);}

#define NEWMSGRESP(ptr,type,pe,os,t,gs,gr,r,c)\
    	{ /*pcount[101]++;*/ /*palloc(MESSAGE,1,ptr);*/\
    	Malloc_Message(ptr);\
    	INSERT_MSGTYPE(ptr, type);\
    	INSERT_MSGPENUM(ptr, pe);\
	INSERT_MSGOSBK(ptr, os);\
	INSERT_MSGTASKID(ptr, t);\
    	INSERT_MSGGSLOT(ptr, gs);\
	INSERT_MSGRESP(ptr, gr);\
	INSERT_MSGRNUM(ptr, r);\
	INSERT_MSGCNUM(ptr, c);}


/************************************************************************/
/*									*/
/*			CLAUSE  MACROS					*/
/*									*/
/************************************************************************/


#define ClauseNumNodes(C)	(C)->num_nodes
#define ClauseNumArcs(C)	(C)->num_arcs
#define ClauseNumVars(C)	(C)->num_vars
#define ClauseLitPos(C,L)	(C)->lit_position[L]
#define ClauseSuccNode(C,A)	(C)->succ_node[A]
#define ClauseSuccArcs(C,N)	(C)->succ_arcs[N]
#define ClausePredArcs(C,N)	(C)->pred_arcs[N]

#define PgmIsFact(clause)	((clause)->num_arcs == 0)

#define PgmGetSubGoal(clause,index)		((clause)->lit_position[index])

#define PgmIsClauseDet(clause)	((clause)->clause_det)
#define PgmSetClauseDet(clause) ((clause)->clause_det = 1)

#define PgmLitIsDet(clause,index) (BitInVector((clause)->lit_det,(index)))

#define PgmLitIsNoFail(clause,index) \
       (BitInVector((clause)->lit_cannot_fail,(index)))

#define PgmSharedTuple(clause,index)	((clause)->shared_tuple[index])

#define PgmPredCount(clause,index)	((clause)->pred_count[index])
#define PgmSuccCount(clause,index)	((clause)->succ_count[index])

#define PgmGetBuiltin(clause,index)	((clause)->builtin_index[index])

#define JOIN_NODE(c,node)		(c->pred_count[node]>=2)
#define BRANCH_NODE(c,node)		(c->succ_count[node]>=2)


